% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{NNS.reg}
\alias{NNS.reg}
\title{NNS Regression}
\usage{
NNS.reg(x, y, order = NULL, stn = 0.99, dim.red.method = NULL,
  tau = NULL, type = NULL, point.est = NULL, location = "top",
  return.values = TRUE, plot = TRUE, plot.regions = FALSE,
  residual.plot = TRUE, std.errors = FALSE, confidence.interval = NULL,
  threshold = 0, n.best = NULL, noise.reduction = "mean", norm = NULL,
  dist = "L2", multivariate.call = FALSE)
}
\arguments{
\item{x}{a vector, matrix or data frame of variables of numeric or factor data types.}

\item{y}{a numeric or factor vector with compatible dimsensions to \code{x}.}

\item{order}{integer; Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{(order = ...)} integer settings with \code{(noise.reduction="off")}.  \code{(order = "max")} will force a limit condition perfect fit.}

\item{stn}{numeric [0, 1]; Signal to noise parameter, sets the threshold of \code{(NNS.dep)} which reduces \code{("order")} when \code{(order = NULL)}.  Defaults to 0.99 to ensure high dependence for higher \code{("order")} and endpoint determination.}

\item{dim.red.method}{options: ("cor", "NNS.cor", "NNS.caus", "all", NULL) method for determining synthetic X* coefficients.  Selection of a method automatically engages the dimension reduction regression.  The default is \code{NULL} for full multivariate regression.  \code{(dim.red.method = "NNS.cor")} uses \link{NNS.cor} for nonlinear correlation weights, while \code{(dim.red.method = "NNS.caus")} uses \link{NNS.caus} for causal weights.  \code{(dim.red.method = "cor")} uses standard linear correlation for weights.  \code{(dim.red.method = "all")} averages all methods for further feature engineering.}

\item{tau}{options("ts", NULL); \code{NULL}(default) If \code{(dim.red.method = "NNS.caus")} or

\code{(dim.red.method = "all")} and the regression is using time-series data, set \code{(tau = "ts")} for more accurate causal analysis.}

\item{type}{\code{NULL} (default).  To perform a classification, set to \code{(type = "CLASS")}.}

\item{point.est}{a numeric or factor vector with compatible dimsensions to \code{x}.  Returns the fitted value \code{y.hat} for any value of \code{x}.}

\item{location}{Sets the legend location within the plot, per the \code{x} and \code{y} co-ordinates used in base graphics \link{legend}.}

\item{return.values}{logical; \code{TRUE} (default), set to \code{FALSE} in order to only display a regression plot and call values as needed.}

\item{plot}{logical; \code{TRUE} (default) To plot regression.}

\item{plot.regions}{logical; \code{FALSE} (default).  Generates 3d regions associated with each regression point for multivariate regressions.  Note, adds significant time to routine.}

\item{residual.plot}{logical; \code{TRUE} (default) To plot \code{y.hat} and \code{Y}.}

\item{std.errors}{logical; \code{FALSE} (default) To provide standard errors of each linear segment in the \code{"Fitted.xy"} output.}

\item{confidence.interval}{numeric [0,1]; \code{NULL} (default) Plots the associated confidence interval with the estimate and reports the standard error for each individual segment.}

\item{threshold}{numeric [0, 1]; \code{(threshold = 0)} (default) Sets the threshold for dimension reduction of independent variables when \code{(dim.red.method)} is not \code{NULL}.}

\item{n.best}{integer; \code{NULL} (default) Sets the number of nearest regression points to use in weighting for multivariate regression at \code{sqrt(# of regressors)}.  \code{(n.best = "all")} will select and weight all generated regression points.  Analogous to \code{k} in a
\code{k Nearest Neighbors} algorithm.  Different values of \code{n.best} are tested using cross-validation in \link{NNS.stack}.}

\item{noise.reduction}{the method of determing regression points options: ("mean", "median", "mode", "off"); In low signal:noise situations,\code{(noise.reduction = "mean")}  uses means for \link{NNS.dep} restricted partitions, \code{(noise.reduction = "median")}  uses medians instead of means for \link{NNS.dep} restricted partitions, while \code{(noise.reduction = "mode")}  uses modes instead of means for \link{NNS.dep} restricted partitions.  \code{(noise.reduction = "off")}  allows for maximum possible fit with a specific \code{order}.}

\item{norm}{\code{NULL} (default) the method of normalization options: ("NNS", "std"); Normalizes \code{x} between 0 and 1 for multivariate regression when set to \code{(norm = "std")}, or normalizes \code{x} according to \link{NNS.norm} when set to \code{(norm = "NNS")}.}

\item{dist}{options:("L1", "L2") the method of distance calculation; Selects the distance calculation used. \code{dist = "L2"} (default) selects the Euclidean distance and \code{(dist = "L1")} seclects the Manhattan distance.}

\item{multivariate.call}{Internal parameter for multivariate regressions.}
}
\value{
UNIVARIATE REGRESSION RETURNS THE FOLLOWING VALUES:
\itemize{
 \item{\code{"R2"}} provides the goodness of fit;

 \item{\code{"SE"}} returns the overall standard error of the estimate between \code{y} and \code{y.hat};

 \item{\code{"Prediction.Accuracy"}} returns the correct rounded \code{"Point.est"} used in classifications versus the categorical \code{y};

 \item{\code{"derivative"}} for the coefficient of the \code{x} and its applicable range;

 \item{\code{"Point"}} returns the \code{x} point(s) being evaluated;

 \item{\code{"Point.est"}} for the predicted value generated;

 \item{\code{"regression.points"}} provides the points used in the regression equation for the given order of partitions;

 \item{\code{"Fitted"}} returns a vector containing only the fitted values, \code{y.hat};

 \item{\code{"Fitted.xy"}} returns a \link{data.table} of \code{x},\code{y}, \code{y.hat}, and \code{NNS.ID};
}


MULTIVARIATE REGRESSION RETURNS THE FOLLOWING VALUES:
\itemize{
 \item{\code{"R2"}} provides the goodness of fit;

 \item{\code{"equation"}} returns the numerator of the synthetic X* dimension reduction equation as a \link{data.table} consisting of regressor and its coefficient.  Denominator is simply the length of all coefficients > 0, returned in last row of \code{equation} data.table.

 \item{\code{"x.star"}} returns the synthetic X* as a vector;

 \item{\code{"rhs.partitions"}} returns the partition points for each regressor \code{x};

 \item{\code{"RPM"}} provides the Regression Point Matrix, the points for each \code{x} used in the regression equation for the given order of partitions;

 \item{\code{"Point.est"}} returns the predicted value generated;

 \item{\code{"Fitted"}} returns a vector containing only the fitted values, \code{y.hat};

 \item{\code{"Fitted.xy"}} returns a \link{data.table} of \code{x},\code{y}, \code{y.hat}, \code{gradient}, and \code{NNS.ID}.
}
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\note{
Please ensure \code{point.est} is of compatible dimensions to \code{x}, error message will ensue if not compatible.  Also, upon visual inspection of the data, if a highly periodic variable is observed set \code{(stn = 0)} or \code{(order = "max")} to ensure a proper fit.

Identical regressors can be used as long as they do not share the same name. For instance,
\code{NNS.reg(cbind(x, 1 * x), y)} will work as \code{NNS.reg} is not affected by multicollinearity.

\code{NNS (>= v.0.3.4)} has repurposed parameter \code{(type = "CLASS")}.  \code{(type = "CLASS")} is now restricted to signifying a classification analysis for \code{NNS.reg} while \code{(dim.red.method)} enables dimension reduction regressions.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.reg(x, y)

## Manual {order} selection
NNS.reg(x, y, order = 2)

## Maximum {order} selection
NNS.reg(x, y, order = "max")

## x-only paritioning (Univariate only)
NNS.reg(x, y, type = "XONLY")

## For Multiple Regression:
x <- cbind(rnorm(100), rnorm(100), rnorm(100)) ; y <- rnorm(100)
NNS.reg(x, y, point.est = c(.25, .5, .75))

## For Multiple Regression based on Synthetic X* (Dimension Reduction):
x <- cbind(rnorm(100), rnorm(100), rnorm(100)) ; y<-rnorm(100)
NNS.reg(x, y, point.est = c(.25, .5, .75), dim.red.method = "cor")

## IRIS dataset examples:
# Dimension Reduction:
NNS.reg(iris[,1:4], iris[,5], dim.red.method = "cor", order = 5)

# Dimension Reduction using causal weights:
NNS.reg(iris[,1:4], iris[,5], dim.red.method = "NNS.caus", order = 5)

# Multiple Regression:
NNS.reg(iris[,1:4], iris[,5], order = 2, noise.reduction = "off")

# Classification:
NNS.reg(iris[,1:4], iris[,5], point.est = iris[1:10, 1:4], type = "CLASS")$Point.est

## To call fitted values:
x <- rnorm(100) ; y <- rnorm(100)
NNS.reg(x, y)$Fitted

## To call partial derivative (univariate regression only):
x <- rnorm(100) ; y <- rnorm(100)
NNS.reg(x, y)$derivative

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"
\url{https://link.springer.com/article/10.1007/s10614-017-9713-5}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{classifier}
\keyword{nonlinear}
\keyword{regression,}
