% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{NNS.CDF}
\alias{NNS.CDF}
\title{NNS CDF}
\usage{
NNS.CDF(variable, degree = 0, target = NULL, type = "CDF", plot = TRUE)
}
\arguments{
\item{variable}{a numeric vector or data.frame of 2 variables for joint CDF.}

\item{degree}{integer; \code{(degree = 0)} (default) is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; \code{NULL} (default) Must lie within support of each variable.}

\item{type}{options("CDF", "survival", "hazard", "cumulative hazard"); \code{"CDF"} (default) Selects type of function to return for bi-variate analysis.  Multivariate analysis is restricted to \code{"CDF"}.}

\item{plot}{logical; plots CDF.}
}
\value{
Returns:
\itemize{
 \item{\code{"Function"}} a data.table containing the observations and resulting CDF of the variable.
 \item{\code{"target.value"}} value from the \code{target} argument.
}
}
\description{
This function generates an empirical CDF using partial moment ratios \link{LPM.ratio}, and resulting survival, hazard and cumulative hazard functions.
}
\examples{
set.seed(123)
x <- rnorm(100)
NNS.CDF(x)

\dontrun{
## Empirical CDF (degree = 0)
NNS.CDF(x)

## Continuous CDF (degree = 1)
NNS.CDF(x, 1)

## Joint CDF
x <- rnorm(5000) ; y <- rnorm(5000)
A <- cbind(x,y)

NNS.CDF(A, 0)

## Joint CDF with target
NNS.CDF(A, 0, target = c(0,0))
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995}

Viole, F. (2017) "Continuous CDFs and ANOVA with NNS"
\url{https://ssrn.com/abstract=3007373}
}
\author{
Fred Viole, OVVO Financial Systems
}
