# FROM NNS-Python
x <- c(0.6964691855978616, 0.28613933495037946, 0.2268514535642031, 0.5513147690828912, 0.7194689697855631, 0.42310646012446096, 0.9807641983846155, 0.6848297385848633, 0.48093190148436094, 0.3921175181941505, 0.3431780161508694, 0.7290497073840416, 0.4385722446796244, 0.05967789660956835, 0.3980442553304314, 0.7379954057320357, 0.18249173045349998, 0.17545175614749253, 0.5315513738418384, 0.5318275870968661, 0.6344009585513211, 0.8494317940777896, 0.7244553248606352, 0.6110235106775829, 0.7224433825702216, 0.3229589138531782, 0.3617886556223141, 0.22826323087895561, 0.29371404638882936, 0.6309761238544878, 0.09210493994507518, 0.43370117267952824, 0.4308627633296438, 0.4936850976503062, 0.425830290295828, 0.3122612229724653, 0.4263513069628082, 0.8933891631171348, 0.9441600182038796, 0.5018366758843366, 0.6239529517921112, 0.11561839507929572, 0.3172854818203209, 0.4148262119536318, 0.8663091578833659, 0.2504553653965067, 0.48303426426270435, 0.985559785610705, 0.5194851192598093, 0.6128945257629677, 0.12062866599032374, 0.8263408005068332, 0.6030601284109274, 0.5450680064664649, 0.3427638337743084, 0.3041207890271841, 0.4170222110247016, 0.6813007657927966, 0.8754568417951749, 0.5104223374780111, 0.6693137829622723, 0.5859365525622129, 0.6249035020955999, 0.6746890509878248, 0.8423424376202573, 0.08319498833243877, 0.7636828414433382, 0.243666374536874, 0.19422296057877086, 0.5724569574914731, 0.09571251661238711, 0.8853268262751396, 0.6272489720512687, 0.7234163581899548, 0.01612920669501683, 0.5944318794450425, 0.5567851923942887, 0.15895964414472274, 0.1530705151247731, 0.6955295287709109, 0.31876642638187636, 0.6919702955318197, 0.5543832497177721, 0.3889505741231446, 0.9251324896139861, 0.8416699969127163, 0.35739756668317624, 0.04359146379904055, 0.30476807341109746, 0.398185681917981, 0.7049588304513622, 0.9953584820340174, 0.35591486571745956, 0.7625478137854338, 0.5931769165622212, 0.6917017987001771, 0.15112745234808023, 0.39887629272615654, 0.24085589772362448, 0.34345601404832493)
y <- c(0.9290953494701337, 0.3001447577944899, 0.20646816984143224, 0.7712467017344186, 0.179207683251417, 0.7203696347073341, 0.2978651188274144, 0.6843301478774432, 0.6020774780838681, 0.8762070150459621, 0.7616916032270227, 0.6492402854114879, 0.3486146126960078, 0.5308900543442001, 0.31884300700035195, 0.6911215594221642, 0.7845248814489976, 0.8626202294885787, 0.4135895282244193, 0.8672153808700541, 0.8063467153755893, 0.7473209976914339, 0.08726848196743031, 0.023957638562143946, 0.050611236457549946, 0.4663642370285497, 0.4223981453920743, 0.474489623129292, 0.534186315014437, 0.7809131772951494, 0.8198754325768683, 0.7111791151322316, 0.49975889646204175, 0.5018097125708618, 0.7991356578408818, 0.03560152015693441, 0.921601798248779, 0.2733414160633679, 0.7824828518318679, 0.395582605302746, 0.48270235978971854, 0.5931259692926043, 0.2731798106977692, 0.8570159493264954, 0.5319561444631024, 0.1455315278392807, 0.6755524321238062, 0.27625359167650576, 0.2723010177649897, 0.6810977486565571, 0.9493047259244862, 0.807623816061548, 0.9451528088524095, 0.6402025296719795, 0.8258783277528565, 0.6300644920352498, 0.3893090155420259, 0.24163970305689175, 0.18402759570852467, 0.6031603131688895, 0.6566703304734626, 0.21177484928830181, 0.4359435889362071, 0.22965129132316398, 0.13087653733774363, 0.5989734941782344, 0.6688357426448118, 0.8093723729154483, 0.36209409565006223, 0.8513351315065957, 0.6551606487241549, 0.8554790691017261, 0.13596214615618918, 0.10883347378170816, 0.5448015917555307, 0.8728114143337533, 0.6621652225678912, 0.8701363950944805, 0.8453249339337617, 0.6283199211390311, 0.20690841095962864, 0.5176511518958, 0.6448515562981659, 0.42666354124364536, 0.9718610781333566, 0.24973274985042482, 0.05193778223157797, 0.6469719787522865, 0.3698392148054457, 0.8167218997483684, 0.710280810455504, 0.260673487453131, 0.4218711567383805, 0.793490082297006, 0.9398115107412777, 0.7625379749026492, 0.039750173274282985, 0.040137387046519146, 0.16805410857991787, 0.78433600580123)

T_ORDER <- 2
T_DT <- data.table::data.table(x, y, quadrant = "q", prior.quadrant = "pq")
T_DT$quadrant <- c(
  'q11', 'q44', 'q44', 'q12', 'q34', 'q23', 'q31', 'q13', 'q23', 'q21', 'q23', 'q13', 'q41', 'q42', 'q43', 'q13', 
  'q22', 'q22', 'q32', 'q12', 'q12', 'q13', 'q34', 'q34', 'q34', 'q41', 'q41', 'q42', 'q42', 'q12', 'q22', 'q23', 
  'q41', 'q41', 'q21', 'q44', 'q21', 'q31', 'q11', 'q41', 'q32', 'q24', 'q43', 'q21', 'q31', 'q44', 'q23', 'q31', 
  'q32', 'q14', 'q22', 'q11', 'q12', 'q14', 'q21', 'q23', 'q41', 'q32', 'q33', 'q14', 'q14', 'q34', 'q32', 'q34', 
  'q33', 'q24', 'q13', 'q22', 'q42', 'q12', 'q24', 'q11', 'q34', 'q34', 'q42', 'q12', 'q14', 'q22', 'q22', 'q13', 
  'q43', 'q32', 'q14', 'q41', 'q11', 'q31', 'q43', 'q24', 'q42', 'q21', 'q13', 'q31', 'q41', 'q11', 'q12', 'q11', 
  'q44', 'q43', 'q44', 'q21'
)
T_DT$prior.quadrant <- c(
  'q1', 'q4', 'q4', 'q1', 'q3', 'q2', 'q3', 'q1', 'q2', 'q2', 'q2', 'q1', 'q4', 'q4', 'q4', 'q1', 'q2', 'q2', 'q3', 
  'q1', 'q1', 'q1', 'q3', 'q3', 'q3', 'q4', 'q4', 'q4', 'q4', 'q1', 'q2', 'q2', 'q4', 'q4', 'q2', 'q4', 'q2', 'q3', 
  'q1', 'q4', 'q3', 'q2', 'q4', 'q2', 'q3', 'q4', 'q2', 'q3', 'q3', 'q1', 'q2', 'q1', 'q1', 'q1', 'q2', 'q2', 'q4', 
  'q3', 'q3', 'q1', 'q1', 'q3', 'q3', 'q3', 'q3', 'q2', 'q1', 'q2', 'q4', 'q1', 'q2', 'q1', 'q3', 'q3', 'q4', 'q1', 
  'q1', 'q2', 'q2', 'q1', 'q4', 'q3', 'q1', 'q4', 'q1', 'q3', 'q4', 'q2', 'q4', 'q2', 'q1', 'q3', 'q4', 'q1', 'q1', 
  'q1', 'q4', 'q4', 'q4', 'q2'
)
T_regression_points <- data.table::data.table(
  "quadrant"= c("q1", "q2", "q3", "q4"),
  "x"=c(0.6699556, 0.2873833, 0.7316866, 0.3142156),
  "y"=c(0.7618939, 0.7711931, 0.2389004, 0.3400069)
)
R1 <- NNS.part(x,y,Voronoi=FALSE)

test_that(
	"NNS.part", {
	  expect_equal(R1$order, T_ORDER, tolerance=1e-5)
	  expect_equal(R1$dt, T_DT, tolerance=1e-5)
	  expect_equal(R1$regression.points, T_regression_points, tolerance=1e-5)
	}
)
