#'Small convenience functions and tests for working with the Net Promoter Score (NPS)
#'
#' \tabular{ll}{
#' Package: \tab NPS\cr
#' Type: \tab Package\cr
#' Version: \tab 0.1\cr
#' Date: \tab 2013-01-29\cr
#' License: \tab GPL (>= 2)\cr
#' LazyLoad: \tab yes\cr
#' }
#'
#'This package provides a few small functions to make working with survey data in an NPS context easier. Specifically, data transformation methods, some methods for examining the statistical properties of the NPS, such as its variance and standard errors, and some simple inferential testing procedures.
#'
#'
#' @name NPS-package
#' @aliases NPS
#' @docType package
#' @author Brendan Rocks \email{rocks.brendan@@gmail.com}
#' @keywords package
NULL

#' This is data to be included in my package
#'
#' An idealised test data set, for demonstrating some of the NPS functions
#'
#' @name testdata
#' @docType data
#' @author Brendan Rocks \email{rocks.brendan@@gmail.com}
#' @keywords data
NULL