% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLE_sNiW.R
\name{MLE_sNiW}
\alias{MLE_sNiW}
\title{MLE for sNiW distributed observations}
\usage{
MLE_sNiW(xi_list, psi_list, S_list, doPlot = TRUE)
}
\arguments{
\item{xi_list}{a list of length \code{N} whose elements are observed vectors of length \code{d}
of the mean parameters xi.}

\item{psi_list}{a list of length \code{N} whose elements are observed vectors of length \code{d}
of the skew parameters psi.}

\item{S_list}{a list of length \code{N} whose elements are observed variance-covariance matrices
of dimension \code{d x d}.}

\item{doPlot}{a logical flag indicating wether the algorithm progression should be plotted.
Default is \code{TRUE}.}
}
\description{
Maximum likelihood estimation of Normal inverse Wishart distributed observations
}
\examples{
hyperG0 <- list()
hyperG0$b_xi <- c(0.3, -1.5)
hyperG0$b_psi <- c(0, 0)
hyperG0$kappa <- 0.001
hyperG0$D_xi <- 100
hyperG0$D_psi <- 100
hyperG0$nu <- 35
hyperG0$lambda <- diag(c(0.25,0.35))

xi_list <- list()
psi_list <- list()
S_list <- list()
for(k in 1:1000){
 NNiW <- rNNiW(hyperG0, diagVar=FALSE)
 xi_list[[k]] <- NNiW[["xi"]]
 psi_list[[k]] <- NNiW[["psi"]]
 S_list[[k]] <- NNiW[["S"]]
}

mle <- MLE_sNiW(xi_list, psi_list, S_list)
mle
}
\author{
Boris Hejblum, Chariff Alkhassim
}
