% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_network_plot.R
\name{multiple.network.plot}
\alias{multiple.network.plot}
\title{Plots networks for multiple conditions}
\usage{
multiple.network.plot(netfacs.graphs)
}
\arguments{
\item{netfacs.graphs}{list of network objects resulting from netfacs.network() function or multiple.netfacs.networks() function}
}
\value{
Function returns a igraph.plot connections between nodes in the different networks. Elements that are significantly more likely to occur than expected are large, non-significant elements are small, and absent elements are absent.
}
\description{
The function takes multiple network objects and plots them next to each other while keeping the element positions etc constant. Uses igraph.plot function
}
\examples{
data(emotions_set)
emo.faces <- multiple.netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  duration = NULL,
  ran.trials = 10, # only for example
  control = NULL,
  random.level = NULL,
  combination.size = 2
)

emo.nets <- multiple.netfacs.network(emo.faces, min.count = 5)
multiple.network.plot(emo.nets)
}
