% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\name{cellFromPxcorPycor}
\alias{cellFromPxcorPycor}
\alias{cellFromPxcorPycor,worldNLR,numeric,numeric-method}
\title{Cells numbers from \code{patches} coordinates}
\usage{
cellFromPxcorPycor(world, pxcor, pycor)

\S4method{cellFromPxcorPycor}{worldNLR,numeric,numeric}(world, pxcor, pycor)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{pxcor}{Integer. Vector of patches \code{pxcor} coordinates. Must be of length 1
or of the same length as \code{pycor}.}

\item{pycor}{Integer. Vector of patches \code{pycor} coordinates. Must be of length 1
or of the same length as \code{pxcor}.}
}
\value{
Numeric. Vector of cells number.
}
\description{
Report the cells numbers as defined for a \verb{Raster*} object given the \code{patches}
coordinates \code{pxcor} and \code{pycor}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
cellFromPxcorPycor(world = w1, pxcor = 0, pycor = 9)
cellFromPxcorPycor(world = w1, pxcor = c(0, 1, 2), pycor = 0)

}
\author{
Sarah Bauduin
}
