% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\name{stackWorlds}
\alias{stackWorlds}
\alias{stackWorlds,worldMatrix-method}
\title{Stack \code{worlds}}
\usage{
stackWorlds(...)

\S4method{stackWorlds}{worldMatrix}(...)
}
\arguments{
\item{...}{\code{worldMatrix} objects. If passed as unnamed objects, then the function
will attempt to use their object names as layer names. Alternatively, to be more
reliable, these can be passed as named arguments. See examples.}
}
\value{
\code{worldArray} object.
}
\description{
Stack multiple \code{worldMatrix} into a \code{worldArray}.
}
\details{
The \code{worldMatrix} objects must all have the same extents.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 1:25)
w2 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 25:1)
w3 <- stackWorlds(w1, w2)
plot(w3)

# pass named arguments to specify a different name than the object name
w4 <- stackWorlds(layer1 = w1, layer2 = w2)

}
\author{
Sarah Bauduin
}
