% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\name{diffuse}
\alias{diffuse}
\alias{diffuse,worldMatrix,missing,numeric,numeric-method}
\alias{diffuse,worldArray,character,numeric,numeric-method}
\title{Diffuse values in a \code{world}}
\usage{
diffuse(world, pVar, share, nNeighbors, torus = FALSE)

\S4method{diffuse}{worldMatrix,missing,numeric,numeric}(world, share, nNeighbors, torus)

\S4method{diffuse}{worldArray,character,numeric,numeric}(world, pVar, share, nNeighbors, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{pVar}{Character. If the \code{world} is a \code{worldArray} object, \code{pVar}
is the name of the layer to use to define the \code{patches} values.
\code{pVar} must not be provided if the \code{world} is a \code{worldMatrix} object.}

\item{share}{Numeric. Value between 0 and 1 representing the portion of
the \code{patches} values to be diffused among the neighbors.}

\item{nNeighbors}{Integer: 4 or 8. Represents the number of neighbor \code{patches}
considered.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
\code{WorldMatrix} or \code{worldArray} object with \code{patches} values updated.
}
\description{
Each \code{patch} gives an equal share of a portion of its value to its neighbor \code{patches}.
}
\details{
What is given is lost for the patches.

         If \code{torus = TRUE}, all \code{patches} have \code{nNeighbors} \code{patches} around
         them, which
         some may be on the other sides of the \code{world}. If \code{torus = FALSE},
         \code{patches} located on the edges of the \code{world} have less than
         \code{nNeighbors} \code{patches} around them.
         However, each neighbor still gets 1/4 or 1/8 of the shared amount
         and the diffusing
         patch keeps the leftover.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = sample(1:3, size = 25, replace = TRUE))
plot(w1)
# Diffuse 50\% of each patch value to its 8 neighbors
w2 <- diffuse(world = w1, share = 0.5, nNeighbors = 8)
plot(w2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#diffuse}

         \url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#diffuse4}
}
\author{
Sarah Bauduin
}
