% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity_avr_weighted.R
\name{proximity_average_weighted}
\alias{proximity_average_weighted}
\title{Proximity from target to source}
\usage{
proximity_average_weighted(G, source, targets)
}
\arguments{
\item{G}{The original graph (often a weighted interactome).}

\item{source}{nodes from the network (in a drug repurpusing set-up those are the disease genes)}

\item{targets}{targets in the network (in a drug repurpusing set-up those are the drug-targets)}
}
\value{
the proximity value for the source-targets
}
\description{
Calculates the weighted average proximity from source to targets.
}
\examples{
set.seed(666)
net  = data.frame(
Node.1 = sample(LETTERS[1:15], 15, replace = TRUE),
Node.2 = sample(LETTERS[1:10], 15, replace = TRUE))
net$value = 1
net =  CoDiNA::OrderNames(net)
net = unique(net)
net$weight = runif(nrow(net))
g <- igraph::graph_from_data_frame(net, directed = FALSE )
T = c("G", "A", "D")
S = c("C", "M")
proximity_average_weighted(g, source = S, targets = T)
}
