% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extintions.R
\name{CompareExtinctions}
\alias{CompareExtinctions}
\title{Comparison of Null hypothesis with other extinction histories}
\usage{
CompareExtinctions(Nullmodel, Hypothesis)
}
\arguments{
\item{Nullmodel}{an object generated by the RandomExtinctions}

\item{Hypothesis}{Extinction history generated by the Mostconnected or ExtinctionOrder
fuction}
}
\value{
a plot comparing the expected value of secondary extinctions originated at random
with the observed extinction history.
}
\description{
It compares an object generated either by the Mostconnected or ExtinctionOrder functions
with a null hypothesis generated by the RandomExtinctions function it is important that
RandomExtinctions is in plot = T.
}
\examples{
\dontrun{
data("Less_Connected")
History <- SimulateExtinctions(Network = Less_Connected, Method = "Mostconnected")
NullHyp <- RandomExtinctions(Network = Less_Connected, nsim = 100)
CompareExtinctions(Nullmodel = NullHyp, Hypothesis = History)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M. Isidora Ávila-Thieme <msavila@uc.cl>
}
