% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance}
\usage{
distance(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to FALSE.
Set to TRUE for weighted measure of distance}
}
\value{
A distance matrix of the network
}
\description{
Computes distance matrix of the network
}
\examples{
A <- TMFG(neoOpen)$A

#Unweighted
Du <- distance(A)

#Weighted
Dw <- distance(A, weighted = TRUE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
