% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{mapestimate}
\alias{mapestimate}
\title{Maximum a posteriori estimation}
\usage{
mapestimate(
  estimator,
  Z,
  prior = NULL,
  theta_grid = NULL,
  theta0 = NULL,
  use_gpu = TRUE
)
}
\arguments{
\item{estimator}{a neural likelihood-to-evidence-ratio estimator}

\item{Z}{data; it's format should be amenable to the architecture of \code{estimator}}

\item{prior}{the prior (default uniform), specified as a Julia or R function}

\item{theta_grid}{a (fine) gridding of the parameter space, given as a matrix with p rows, where p is the number of parameters in the model}

\item{theta0}{a vector of initial parameter estimates}

\item{use_gpu}{a boolean indicating whether to use the GPU if it is available (default true)}
}
\value{
a p × K matrix of MAP estimates, where p is the number of parameters in the statistical model and K is the number of data sets provided in \code{Z}
}
\description{
Given data \code{Z}, a neural likelihood-to-evidence-ratio \code{estimator}, and a \code{prior}, computes the implied approximate maximum a posteriori (MAP) estimate

If a vector \code{theta0} of initial parameter estimates is given, the approximate posterior density is maximised by gradient descent. Otherwise, if a matrix of parameters \code{theta_grid} is given, the approximate posterior density is maximised by grid search.
}
\seealso{
\code{\link[=sampleposterior]{sampleposterior()}}, \code{\link[=mlestimate]{mlestimate()}}
}
