% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingdata.R
\name{spatialgraph}
\alias{spatialgraph}
\title{spatialgraph}
\usage{
spatialgraph(S, Z, isotropic = TRUE, stationary = TRUE, ...)
}
\arguments{
\item{S}{Spatial locations, provided as:
\itemize{
\item An \verb{n x d} matrix when locations are fixed across replicates, where \code{n} is the number
of spatial locations and \code{d} is the spatial dimension (typically \code{d=2}).
\item A list of \verb{n_i x d} matrices when locations vary across replicates, where each matrix
corresponds to the spatial locations of a single replicate.
}}

\item{Z}{Spatial data, provided as:
\itemize{
\item An \verb{n x m} matrix when locations are fixed, where \code{m} is the number of replicates.
\item A list of \code{n_i} vectors when locations vary across replicates, where each vector
corresponds to the data for a single replicate.
}}

\item{isotropic}{Logical. If \code{TRUE}, edge features store the spatial distance (magnitude)
between nodes. If \code{FALSE}, the spatial displacement or spatial location is stored, depending
on the value of \code{stationary}.}

\item{stationary}{Logical. If \code{TRUE}, edge features store the spatial displacement
(vector difference) between nodes, capturing both magnitude and direction. If \code{FALSE},
edge features include the full spatial locations of both nodes.}

\item{...}{Additional keyword arguments from the Julia function \href{https://msainsburydale.github.io/NeuralEstimators.jl/dev/API/utility/#NeuralEstimators.adjacencymatrix}{\code{adjacencymatrix()}}
determine the neighborhood of each node, with the default being a randomly
selected set of \code{k=30} neighbors within a radius of \code{r=0.15} units.}
}
\value{
A \code{GNNGraph} (a \code{JuliaProxy} object) ready for use in a graph neural network.
}
\description{
Constructs a graph object for use in graph neural networks.
}
\examples{
\dontrun{
library("NeuralEstimators")

# Number of replicates and spatial dimension
m <- 5
d <- 2

# Spatial locations fixed for all replicates
n <- 100
S <- matrix(runif(n * d), n, d)
Z <- matrix(runif(n * m), n, m)
g <- spatialgraph(S, Z)

# Spatial locations varying between replicates
n <- sample(50:100, m, replace = TRUE)
S <- lapply(n, function(ni) matrix(runif(ni * d), ni, d))
Z <- lapply(n, function(ni) runif(ni))
g <- spatialgraph(S, Z)
}
}
\seealso{
\code{\link[=spatialgraphlist]{spatialgraphlist()}} for the vectorised version of this function.
}
