% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensitivityPlots.R
\name{SensitivityPlots}
\alias{SensitivityPlots}
\title{Plot sensitivities of a neural network model}
\usage{
SensitivityPlots(
  sens = NULL,
  der = TRUE,
  zoom = TRUE,
  quit.legend = FALSE,
  output = 1
)
}
\arguments{
\item{sens}{\code{SensAnalysisMLP} object created by \code{\link[NeuralSens]{SensAnalysisMLP}} or \code{HessMLP} object
created by \code{\link[NeuralSens]{HessianMLP}}.}

\item{der}{\code{logical} indicating if density plots should be created. By default is \code{TRUE}}

\item{zoom}{\code{logical} indicating if the distributions should be zoomed when there is any of them which is too tiny to be appreciated in the third plot.
\code{\link[ggforce]{facet_zoom}} function from \code{ggforce} package is required.}

\item{quit.legend}{\code{logical} indicating if legend of the third plot should be removed. By default is \code{FALSE}}

\item{output}{\code{numeric} or {character} specifying the output neuron or output name to be plotted.
By default is the first output (\code{output = 1}).}
}
\value{
List with the following plot for each output: \itemize{ \item Plot 1: colorful plot with the
  classification of the classes in a 2D map \item Plot 2: b/w plot with
  probability of the chosen class in a 2D map \item Plot 3: plot with the
  stats::predictions of the data provided if param \code{der} is \code{FALSE}}
}
\description{
Function to plot the sensitivities created by \code{\link[NeuralSens]{SensAnalysisMLP}}.
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try SensAnalysisMLP
sens <- NeuralSens::SensAnalysisMLP(nnetmod, trData = nntrData, plot = FALSE)
NeuralSens::SensitivityPlots(sens)
}
\references{
Pizarroso J, Portela J, Muñoz A (2022). NeuralSens: Sensitivity Analysis of
Neural Networks. Journal of Statistical Software, 102(7), 1-36.
}
