% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl_svm.R
\name{cl_svm}
\alias{cl_svm}
\title{A support vector machine classifier (CL)}
\usage{
cl_svm(ndr_container_or_object = NULL, return_decision_values = TRUE, ...)
}
\arguments{
\item{ndr_container_or_object}{The purpose of this argument is to make the
constructor of the cl_svm classifier works with the magrittr pipe (\%>\%)
operator. This argument should almost never be directly set by the user to
anything other than NULL. If this is set to the default value of NULL, then
the constructor will return a cl_svm object. If this is set to an ndr
container, then a cl_svm object will be added to the container and the
container will be returned. If this argument is set to another ndr object,
then both that ndr object as well as a new cl_svm object will be added to a
new container and the container will be returned.}

\item{return_decision_values}{A Boolean specifying whether the prediction
function should return columns that have the decision values. Setting this
to FALSE will save memory so can be useful when analyzing very large high
temporal resolution data sets. However if this is set to FALSE< metrics
won't be able to compute decoding accuracy measures that are based on the
decision values; e.g., the rm_main_results object won't be able to
calculate normalized rank decision values.}

\item{...}{All parameters that are available in the e1071 package svm()
object should work with this CL object.}
}
\value{
This constructor creates an NDR classifier object with the class
\code{cl_svm}. Like all NDR classifier objects, this classifier will be used by
a cross-validator to learn the relationship between neural activity and
experimental conditions on a training set of data, and then it will be used
to make predictions on a test set of data.
}
\description{
This classifier uses the e1071 package to implement a support vector machine.
}
\details{
A support vector machine (SVM) is a classifier that learns a function \emph{f} that
minimizes the hinge loss between predictions made on the training data, while
also applying a penalty for more complex \emph{f} (the penalty is based on the norm
of \emph{f} in a reproducing kernel Hilbert space). The SVM has a parameter \emph{C} that
controls the trade off between the empirical loss (i.e., a smaller prediction
error on the training set), and the complexity of the \emph{f}. SVMs can use
different kernels to create nonlinear decision boundaries.

SVMs are work on binary classification problems, so to do
multi-class classification, an \emph{all-pairs} classification scheme (which is
the default for the e1071 package). In the all-pairs scheme,training separate
classifiers for all pairs of labels (i.e., if there are 100 different classes
then nchoosek(100, 2) = 4950 different classifiers are trained). Testing the
classifier in all-pairs involves having all classifiers classify the test
point, and then the class label is given to the class the was chosen most
often by the binary classifiers (in the case of a tie in the number of
classes that won a contest the class label is randomly chosen). The decision
values for all-pairs are the number of contests won by each class (for each
test point).
}
\examples{
# using the default e1071 parameters
cl <- cl_svm()

# using a linear kernel
cl <- cl_svm(kernel = "linear")

}
\seealso{
e1071

Other classifier: 
\code{\link{cl_max_correlation}()},
\code{\link{cl_poisson_naive_bayes}()}
}
\concept{classifier}
