% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_zscore.R
\name{fp_zscore}
\alias{fp_zscore}
\title{A feature preprocessor (FP) that z-score normalizes the data}
\usage{
fp_zscore(ndr_container_or_object = NULL)
}
\arguments{
\item{ndr_container_or_object}{The purpose of this argument is to make the
constructor of the fp_zscore feature preprocessor work with the
pipe (|>) operator. This argument should almost never be directly set by
the user to anything other than NULL. If this is set to the default value
of NULL, then the constructor will return a fp_zscore object. If this is
set to an ndr container, then a fp_zscore object will be added to the
container and the container will be returned. If this argument is set to
another ndr object, then both that ndr object as well as a new fp_zscore
object will be added to a new container and the container will be returned.}
}
\value{
This constructor creates an NDR feature preprocessor object with the
class \code{fp_zscore}. Like all NDR feature preprocessor objects, this feature
preprocessor will be used by the cross-validator to pre-process the
training and test data sets.
}
\description{
This feature preprocessor object finds the mean and standard deviation using
the training data. The preprocessor then z-score transforms the training and
test data using this mean and standard deviation by subtracting the mean and
dividing by the standard deviation.
}
\details{
This feature preprocessor object applies z-score normalization to
each feature by calculating the mean and the standard deviation for each
feature using the training data, and then subtracting the mean and dividing
by the standard deviation for each feature in the training and test sets.
This function is useful for preventing some classifiers from relying too
heavily on particular features when different features can have very
different ranges of values (for example, it is useful when decoding neural
data because different neurons can have different ranges of firing rates).
}
\examples{
# The fp_zscore() constructor does not take any parameters. This object
# just needs to added to a list and passed to the cross-validator applied
fp <- fp_zscore()
}
\seealso{
Other feature_preprocessor: 
\code{\link{fp_select_k_features}()}
}
\concept{feature_preprocessor}
