% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_data_functions.R
\name{read_raster_data}
\alias{read_raster_data}
\title{Read a csv, rda, rds or mat file in raster format}
\usage{
read_raster_data(raster_file_name)
}
\arguments{
\item{raster_file_name}{A string specifying the name (and path) to a csv,
rda, rds or mat raster data file that has the appropriate raster data
column names (i.e., columns that start with site.info, labels. and time.)}
}
\value{
Returns a data frame of data in \verb{raster format} (i.e., with class
\code{raster_data}). Data that is in \verb{raster format} as the following variables:
\enumerate{
\item \code{labels.XXX}  These variables contain labels of which experimental conditions were shown on a given trial.
\item \code{time.XXX_YYY}  These variables contain the data for a given time, XXX is
the start time of the data in a particular bin and YYY is the end time.
\item \code{site_info.XXX} These variables contain additional meta data about the site.
\item \code{trial_number} This variable specifies a unique number for each row
indicating which trial a given row of data came from.
}

For more details on \verb{raster format} data see the vignette:
\code{vignette("data_formats", package = "NeuroDecodeR")}
}
\description{
Reads a csv, rda, rds or mat file that has the appropriate raster_data
column names (i.e., columns that start with site.info, labels. and time.),
and returns data in raster_data format (i.e., a data frame with the raster.data
class attribute).
}
\examples{
# reading in a csv file in raster format
csv_raster_file_name <- file.path(
  system.file("extdata", package = "NeuroDecodeR"),
  "Zhang_Desimone_7object_raster_data_small_csv",
  "bp1001spk_01A_raster_data.csv"
)

# read the csv file into a raster_data data frame
raster_data <- read_raster_data(csv_raster_file_name)


}
