% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-outcome-dataset.R
\name{ValidateOutcomeDataset}
\alias{ValidateOutcomeDataset}
\title{Validates the schema of datasets containing outcome variables.}
\usage{
ValidateOutcomeDataset(dsOutcome, outcomeNames)
}
\arguments{
\item{dsOutcome}{A \code{data.frame} with the measured variables}

\item{outcomeNames}{The column names of the measure variables that eventually will be used by a statistical procedure.}
}
\value{
Returns \code{TRUE} if the validation passes.
Returns an error (and associated descriptive message) if it false.
}
\description{
The \pkg{NlsyLinks} handles a lot of the plumbing code needed to transform extracted NLSY datasets into a format that statistical routines can interpret.  In some cases, a dataset of measured variables is needed, with one row per subject.  This function validates the measured/outcome dataset, to ensure it posses an interpretable schema.  For a specific list of the requirements, see \code{Details} below.
}
\details{
The \code{dsOutcome} parameter must:
\enumerate{
   \item Have a non-missing value.
   \item Contain at least one row.
   \item Contain a column called 'SubjectTag' (case sensitive).
   \item Have the SubjectTag column containing only positive numbers.
   \item Have the SubjectTag column where all values are unique (ie, two rows/subjects cannot have the same value).
}

The \code{outcomeNames} parameter must:
\enumerate{
   \item Have a non-missing value
   \item Contain only column names that are present in the \code{dsOutcome} data frame.
}
}
\examples{
library(NlsyLinks) #Load the package into the current R session.
ds <- ExtraOutcomes79
outcomeNames <- c("MathStandardized", "WeightZGenderAge")
ValidateOutcomeDataset(dsOutcome=ds, outcomeNames=outcomeNames) #Returns TRUE.
outcomeNamesBad <- c("MathMisspelled", "WeightZGenderAge")
#ValidateOutcomeDataset(dsOutcome=ds, outcomeNames=outcomeNamesBad) #Throws error.

}
\author{
Will Beasley
}
\keyword{validation}

