% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VolcanoPlot.r
\name{VolcanoPlot}
\alias{VolcanoPlot}
\title{Volcano plot}
\usage{
VolcanoPlot(coef, pvals, cexcutoff = 0.7, cexlab = 0.5, pointsize = 0.9,
  plimit = 0.05, coeflimit = 1, negcontrol = NULL, poscontrol = NULL,
  saveplot = FALSE, plotname = "VolcanoPlot", savetype = c("png", "bmp",
  "jpeg", "tiff", "pdf"), xlab = "Coefficients", ylab = "-log(p-value)",
  labelunderlim = FALSE, labelsig = FALSE, interactiveplot = TRUE,
  saveinteractiveplot = FALSE,
  interactiveplotname = "interactiveVolcanPlot", interactiveonly = FALSE,
  main = "Volcano Plot", fclabel = "", chooselegend = NULL,
  vlines = TRUE, tolabel = NULL, ...)
}
\arguments{
\item{coef}{A vector of coefficients with metabolite names.}

\item{pvals}{A vector of corresponding p-values.}

\item{cexcutoff}{Font size of the cut-off labels.}

\item{cexlab}{Font size of the variable labels.}

\item{pointsize}{A numeric indicating the size of the points on the graph.}

\item{plimit}{A numeric indicating the p value cutoff. The default is set to
0.05.}

\item{coeflimit}{A numeric indicating the lower fold cutoff. The default is
set to 2.}

\item{negcontrol}{A vector with the names of the metabolites used as negative controls,
to be coloured differently.}

\item{poscontrol}{A vector with the names of the metabolites used as positive controls,
to be coloured differently.}

\item{saveplot}{A logical indicator whether to save the produced plot.}

\item{plotname}{A character string indicating the name to be used for saving the plot.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{xlab}{\emph{x}-axis label.}

\item{ylab}{\emph{y}-axis label.}

\item{labelunderlim}{A logical indicating whether to label points that are not significant.}

\item{labelsig}{A logical indicating whether all significant points should be labeled.}

\item{interactiveplot}{A logical indication whether an interactive plot should be shown.}

\item{saveinteractiveplot}{A logical indication whether the interactive plot produced should
be saved as a \code{.html} file.}

\item{interactiveplotname}{A character string indicating the name to be used for saving the
interactive plot.}

\item{interactiveonly}{A boolean whether only an interactive version of the plot is required}

\item{main}{Plot title.}

\item{fclabel}{An optional character sting to label the vertical coefficient cutoff.}

\item{chooselegend}{Defualt to \code{NULL}. For internal use in other functions in the package.}

\item{vlines}{A logical indicating whether to show vertical coefficient cutoff lines.}

\item{tolabel}{A list of metabolite names on the graph to be labeled}

\item{...}{Other graphical parameters. See \code{\link[graphics]{par}}.}
}
\description{
Produces a volcano plot given fold changes and p-values.
}
\examples{
 data("alldata_eg")
logdata<-LogTransform(alldata_eg$featuredata)
sampledata<-alldata_eg$sampledata
metabolitedata<-alldata_eg$metabolitedata
imp <-  MissingValues(logdata$featuredata,sampledata,metabolitedata,
                     feature.cutof=0.8, sample.cutoff=0.8, method="knn")
featuredata<-imp$featuredata
qcmets<-which(metabolitedata[,1]=="IS")
factormat<-model.matrix(~gender +Age , sampledata)

#Linear model fit with ordinary statistics with ruv2
ordFit_ruv2<-LinearModelFit(featuredata=featuredata,
                           factormat=factormat,
                           ruv2=TRUE, qcmets=qcmets,
                           k=2)
#Volcano plot
VolcanoPlot(coef=ordFit_ruv2$coefficients[,3], 
           pval=ordFit_ruv2$p.value[,3],
           cexlab = 0.8, 
           interactiveplot = TRUE, 
           coeflimit = 0.05,
           xlab="Coef",
           negcontrol= rownames(ordFit_ruv2$coefficients)
           [which(metabolitedata[,2]==1)],
           poscontrol= c("m74", "m161"),
           interactiveonly = TRUE)
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
