% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcResonances.R
\name{calcResonances}
\alias{calcResonances}
\title{Calculate Resonance Frequencies}
\usage{
calcResonances(odenet)
}
\arguments{
\item{odenet}{Object of class \code{\link{ODEnetwork}}.}
}
\value{
a data frame with a vector of resonance frequencies.
}
\description{
Calculates the resonance frequencies of a given \code{\link{ODEnetwork}}.
The resonance frequencies are calculated without respect to the dampers and neighbourhood structure.
}
\examples{
masses <- 1
dampers <- as.matrix(0.1)
springs <- as.matrix(4)
odenet <- ODEnetwork(masses, dampers, springs)
calcResonances(odenet)
}
