% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simuNetwork.R
\name{simuNetwork}
\alias{simuNetwork}
\title{Simulation of the Differential Equations}
\usage{
simuNetwork(odenet, times, origin.min.time = FALSE, ...)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{times}{[\code{numeric}]\cr
Time sequence to calculate or simulate the ode network.}

\item{origin.min.time}{[\code{logical(1L)}]\cr
Define origin of ode time.
\code{FALSE} sets it to 0, \code{TRUE} to the minimum of \code{times}.
Default is \code{FALSE}.}

\item{...}{Additional arguments.}
}
\value{
an extended list of class [\code{\link{ODEnetwork}}].
}
\description{
Simulates the given \code{\link{ODEnetwork}} over a time range.
}
\examples{
masses <- 4:6
dampers <- diag(1:3)
springs <- diag(7:9)
odenet <- ODEnetwork(masses, dampers, springs)
position <- rep(10, 3)
velocity <- rep(0, 3)
odenet <- setState(odenet, position, velocity)
odenet <- simuNetwork(odenet = odenet, times = seq(0, 20))
}
