% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarImp.R
\name{VarImp}
\alias{VarImp}
\title{variable importance of oblique decision random forest}
\usage{
VarImp(forest, X, y)
}
\arguments{
\item{forest}{An object of class \code{\link{ODRF}}.}

\item{X}{An n by d numerical matrix (preferably) or data frame is used in the \code{ODRF}.}

\item{y}{A response vector of length n is used in the \code{ODRF}.}
}
\value{
A matrix of importance measure, first column is the predictors and second column is Increased error. Misclassification rate (MR) for classification or mean square error (MSE) for regression.
The larger the increased error the more important the variable is.
}
\description{
Variable importance is computed from permuting OOB data.
}
\details{
A note from \code{randomForest} package, here are the definitions of the variable importance measures. The measure is computed from permuting OOB data: For each tree, the prediction error on the out-of-bag portion of the data is recorded.
Then the same is done after permuting each predictor variable. The difference between the two are then averaged over all trees.
}
\examples{
data(breast_cancer)
set.seed(221212)
train <- sample(1:569, 200)
train_data <- data.frame(breast_cancer[train, -1])
test_data <- data.frame(breast_cancer[-train, -1])
\donttest{
forest <- ODRF(diagnosis ~ ., train_data, split = "gini", parallel = FALSE)
(varimp <- VarImp(forest, train_data[, -1], train_data[, 1]))
}
}
\seealso{
\code{\link{ODRF}} \code{\link{Accuracy}} \code{\link{plot.VarImp}}
}
\keyword{forest}
