% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotMat.R
\name{RotMatPPO}
\alias{RotMatPPO}
\title{Create a Projection Matrix: RotMatPPO}
\usage{
RotMatPPO(
  X,
  y,
  model = "PPR",
  split = "entropy",
  weights = NULL,
  dimProj = min(ceiling(length(y)^0.4), ceiling(ncol(X) * 2/3)),
  numProj = ifelse(dimProj == "Rand", sample(floor(ncol(X)/3), 1),
    ceiling(ncol(X)/dimProj)),
  catLabel = NULL,
  ...
)
}
\arguments{
\item{X}{An n by d numeric matrix (preferable) or data frame.}

\item{y}{A response vector of length n.}

\item{model}{Model for projection pursuit (for details see \code{\link{PPO}}).}

\item{split}{One of three criteria, 'gini': gini impurity index (classification), 'entropy': information gain (classification, default)
or 'mse': mean square error (regression).}

\item{weights}{A vector of length same as \code{data} that are positive weights. (default NULL)}

\item{dimProj}{Number of variables to be projected, \code{dimProj}=min(ceiling(n^0.4),ceiling(ncol(X)*2/3)) (default) or dimProj="Rand": random from 1 to ncol(X).}

\item{numProj}{The number of projection directions, when \code{dimProj}="Rand" default
\code{numProj} = sample(ceiling(ncol(\code{X})/3),1) otherwise default \code{numProj}=ceiling(ncol(\code{X})/\code{dimProj}).}

\item{catLabel}{A category labels of class \code{list} in predictors. (default NULL, for details see Examples of \code{\link{ODT}})}

\item{...}{Used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{ODT}}.
\itemize{
\item{Variable: Variables to be projected.}
\item{Number: Number of projections.}
\item{Coefficient: Coefficients of the projection matrix.}
}
}
\description{
Create a projection matrix using projection pursuit optimization (\code{\link{PPO}}).
}
\examples{
set.seed(220828)
X <- matrix(rnorm(1000), 100, 10)
y <- (rnorm(100) > 0) + 0
(RotMat <- RotMatPPO(X, y))
(RotMat <- RotMatPPO(X, y, dimProj = "Rand"))
(RotMat <- RotMatPPO(X, y, dimProj = 6, numProj = 4))

# classification
data(seeds)
(PP <- RotMatPPO(seeds[, 1:7], seeds[, 8], model = "Log", split = "entropy"))
(PP <- RotMatPPO(seeds[, 1:7], seeds[, 8], model = "PPR", split = "entropy"))
(PP <- RotMatPPO(seeds[, 1:7], seeds[, 8], model = "LDA", split = "entropy"))

# regression
data(body_fat)
(PP <- RotMatPPO(body_fat[, 2:15], body_fat[, 1], model = "Log", split = "mse"))
(PP <- RotMatPPO(body_fat[, 2:15], body_fat[, 1], model = "Rand", split = "mse"))
(PP <- RotMatPPO(body_fat[, 2:15], body_fat[, 1], model = "PPR", split = "mse"))

}
\seealso{
\code{\link{RotMatMake}} \code{\link{RotMatRand}} \code{\link{RotMatRF}} \code{\link{PPO}}
}
\keyword{rotation}
