% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi.r, R/compassClient.r, R/displayClient.r,
%   R/daydreamClient.r, R/imoClient.r, R/kowaAP7000Client.r, R/octopus600.r,
%   R/octopus900Client.r, R/simG.r
\name{opiClose}
\alias{opiClose}
\alias{compass.opiClose}
\alias{display.opiClose}
\alias{daydream.opiClose}
\alias{imo.opiClose}
\alias{kowaAP7000.opiClose}
\alias{octo600.opiClose}
\alias{octo900.opiClose}
\alias{simG.opiClose}
\title{Close using OPI}
\usage{
opiClose(...)

compass.opiClose()

display.opiClose()

daydream.opiClose()

imo.opiClose()

kowaAP7000.opiClose()

octo600.opiClose()

octo900.opiClose()

simG.opiClose()
}
\arguments{
\item{...}{Implementation specific parameters. See details.}
}
\value{
Returns NULL if close succeeded, otherwise an implementation-dependent
error.

\subsection{Compass}{
  Returns a list of \code{err}, which is an error code, and \code{fixations},
  which is a matrix with three columns: \code{time} (same as \code{time_hw}
  in \code{opiPresent}), \code{x} (degrees relative to the centre of the image
  returned by \code{opiInitialise} - not the PRL), \code{y} (as for x), and one row
  per fixation.
}

\subsection{Display}{
  Shuts the display.
}

\subsection{Daydream}{
  DETAILS
}

\subsection{imo}{
  DETAILS
}

\subsection{KowaAP7000}{
  DETAILS
}

\subsection{Octopus600}{
  DETAILS
}

\subsection{Octopus900}{
  Returns NULL.
}

\subsection{SimGaussian}{
  DETAILS
}
}
\description{
Generic function for closing the chosen OPI implementation that is set
with \code{chooseOpi()}
}
\examples{
chooseOpi("SimGaussian")
if (!is.null(opiInitialize(sd=2)))
  stop("opiInitialize failed")
if (!is.null(opiClose()))
  stop("opiClose failed, which is very surprising!")
}
\seealso{
\code{\link{chooseOpi}}
}
