% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSMscale-package.R
\docType{package}
\name{OSMscale-package}
\alias{OSMscale}
\alias{OSMscale-package}
\title{Add a Scalebar to OpenStreetMap Plots}
\description{
Functionality to handle and project lat-long coordinates,
easily download background maps
and add a correct scale bar to 'OpenStreetMap' plots in any map projection.
There are some other spatially related miscellaneous functions as well.
}
\note{
Get the most recent code updates at \url{https://github.com/brry}
}
\examples{

d <- read.table(sep=",", header=TRUE, text=
"lat, long
55.685143, 12.580008
52.514464, 13.350137
50.106452, 14.419989
48.847003, 2.337213
51.505364, -0.164752")

# zoom set to 3 to speed up tests. automatic zoom determination is better.
map <- pointsMap(d, type="maptoolkit-topo", utm=TRUE, scale=FALSE, zoom=3, pch=16, col=2)
scaleBar(map, abslen=500, y=0.8, cex=0.8)
lines(projectPoints(d$lat, d$long), col="blue", lwd=2)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, June 2016
}
\seealso{
\code{\link{scaleBar}}, \code{\link{pointsMap}}, \code{\link{projectPoints}}
}
\keyword{documentation}
\keyword{package}

