% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{RelDivers}
\alias{RelDivers}
\title{A function to compute multigroup relative diversity index}
\usage{
RelDivers(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}
}
\value{
Multigroup relative diversity index
}
\description{
The relative diversity index is a multigroup 
index based on Simpson's interaction index \code{\link{ISimpson}}
}
\examples{
x <- segdata@data[ ,1:2]
RelDivers(x) 
}
\references{
Carlson S. M. (1992) \emph{Trends in race/sex 
occupational inequality:  conceptual and measurement issues}. 
Social Problems, 39, p. 269-290
}
\seealso{
Multigroup indices: 
\code{\link{PMulti}}, \code{\link{GiniMulti}}, \code{\link{DMulti}},  
\code{\link{HMulti}}, \code{\link{CMulti}}

Social diversity indices: 
\code{\link{HShannon}}, \code{\link{NShannon}}, 
\code{\link{ISimpson}},
}

