% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{perimeter}
\alias{perimeter}
\title{A function to compute the spatial units' perimeters}
\usage{
perimeter(spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{spatobj}{- a spatial object (class sf, sfc or sfg) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
A perimeter vector
}
\description{
The function is based on on \pkg{sf} and \pkg{lwgeom}  
packages and can be used with a shape file or an R spatial object 
(class sf, sfc or sfg).
}
\examples{
 perimeter(segdata)  
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
perimeter(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices 
computation:  \code{\link{area}}, \code{\link{contig}}, 
\code{\link{distance}}, \code{\link{distcenter}}, 
\code{\link{boundaries}}
}
