% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_plate_randomizer.R
\name{olink_displayPlateLayout}
\alias{olink_displayPlateLayout}
\title{Plot all plates colored by a variable}
\usage{
olink_displayPlateLayout(
  data,
  fill.color,
  PlateSize = 96,
  include.label = FALSE
)
}
\arguments{
\item{data}{tibble/data frame in long format returned from the olink_plate_randomizer function.}

\item{fill.color}{Column name to be used as coloring variable for wells.}

\item{PlateSize}{Integer. Either 96 or 48. 96 is default.}

\item{include.label}{Should the variable group be shown in the plot.}
}
\value{
An object of class "ggplot" showing each plate in a facet with the cells colored by values in column fill.color in input \code{data}.
}
\description{
Displays each plate in a facet with cells colored by the given variable using ggplot and ggplot2::geom_tile.
}
\examples{
\donttest{randomized.manifest <- olink_plate_randomizer(manifest)}
\donttest{olink_displayPlateLayout(data = randomized.manifest, fill.color="Site")}

}
\seealso{
\itemize{
\item{\code{\link[OlinkAnalyze:olink_plate_randomizer]{olink_plate_randomizer()}} for generating a plating scheme}
\item{\code{\link[OlinkAnalyze:olink_displayPlateDistributions]{olink_displayPlateDistributions()}} for validating that sites are properly randomized}
}
}
\keyword{ggplot}
\keyword{plates}
\keyword{randomized}
