% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_anosim.R
\name{pairwise_anosim}
\alias{pairwise_anosim}
\title{Pairwise anosim (ANOSIM) computation}
\usage{
pairwise_anosim(x, groups, p.adjust.method = "bonferroni", perm = 999)
}
\arguments{
\item{x}{A distance matrix in the form of \link[stats]{dist}.
Obtained from a dissimilarity metric, in the case of similarity metric please use \code{1-dist}}

\item{groups}{A vector (column from a table) of labels.}

\item{p.adjust.method}{P adjust method see \link[stats]{p.adjust}}

\item{perm}{Number of permutations to compare against the null hypothesis of anosim (default: \code{perm=999}).}
}
\value{
A \link[base]{data.frame} of
\itemize{
\item pairs that are used
\item R2 of H_0
\item p value of F^p > F
\item p adjusted
}
}
\description{
Computes pairwise \link[vegan]{anosim}, given a distance matrix and a vector of labels.
This function is built into the class \link{omics} with method \code{ordination()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
# Create random data
set.seed(42)
mock_data <- matrix(rnorm(15 * 10), nrow = 15, ncol = 10)

# Create euclidean dissimilarity matrix
mock_dist <- dist(mock_data, method = "euclidean")

# Define group labels, should be equal to number of columns and rows to dist
mock_groups <- rep(c("A", "B", "C"), each = 5)

# Compute pairwise anosim
result <- pairwise_anosim(x = mock_dist, 
                          groups = mock_groups, 
                          p.adjust.method = "bonferroni", 
                          perm = 99)
}
\seealso{
\link[vegan]{anosim}
}
