% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_genes.R
\name{cluster_genes}
\alias{cluster_genes}
\title{cluster_genes}
\usage{
cluster_genes(data, max_range = 20, clusters = NULL, modelNames = NULL)
}
\arguments{
\item{data}{data frame containing processed expression file from score_genes with LFCscore; class - data frame}

\item{max_range}{number of clusters to consider during model selection; default 20 clusters; class - integer}

\item{clusters}{number of clusters to test not based on the best BIC output, user also needs to supply modelNames; class - integer}

\item{modelNames}{can only be supplied when clusters are also specified, this option will model based on the user parameters; class - string}
}
\value{
A data frame object that contains a summary of clusters as well as clustering and summary plots
}
\description{
Function helps to select an optimal number of clusters and a model to be fitted during the EM phase of clustering for Gaussian Mixture Models. The function provides summaries and helps to visualise  gene clusters based on generated data using score_genes function. Weighed gene expression is clustered based on the interactome complexity, i.e., the number of known interactors according to STRING DB, with a cutoff of 700 for the score threshold. The function also provides scatter plotting and dimension reduction plots to analyse the clusters and features in the experimental data.
}
\examples{
 \dontrun{
path_to_test_data<- system.file("extdata", "test_scores.tabular", package="OmicInt")
# basic usage of cluster_genes
df<-utils::read.table(path_to_test_data)
df<-cluster_genes(df)
head(df)
}
}
