% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS_o2m.R
\name{o2m}
\alias{o2m}
\title{Perform O2-PLS with two-way orthogonal corrections}
\usage{
o2m(X, Y, n, nx, ny, stripped = FALSE, p_thresh = 3000,
  q_thresh = p_thresh, tol = 1e-10, max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{n}{Integer. Number of joint PLS components. Must be positive!}

\item{nx}{Integer. Number of orthogonal components in \eqn{X}. Negative values are interpreted as 0}

\item{ny}{Integer. Number of orthogonal components in \eqn{Y}. Negative values are interpreted as 0}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{p_thresh}{Integer. If \code{X} has more than \code{p_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{q_thresh}{Integer. If \code{Y} has more than \code{q_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
A list containing
   \item{Tt}{Joint \eqn{X} scores}
   \item{W.}{Joint \eqn{X} loadings}
   \item{U}{Joint \eqn{Y} scores}
   \item{C.}{Joint \eqn{Y} loadings}
   \item{E}{Residuals in \eqn{X}}
   \item{Ff}{Residuals in \eqn{Y}}
   \item{T_Yosc}{Orthogonal \eqn{X} scores}
   \item{P_Yosc.}{Orthogonal \eqn{X} loadings}
   \item{W_Yosc}{Orthogonal \eqn{X} weights}
   \item{U_Xosc}{Orthogonal \eqn{Y} scores}
   \item{P_Xosc.}{Orthogonal \eqn{Y} loadings}
   \item{C_Xosc}{Orthogonal \eqn{Y} weights}
   \item{B_U}{Regression coefficient in \code{Tt} ~ \code{U}}
   \item{B_T.}{Regression coefficient in \code{U} ~ \code{Tt}}
   \item{H_TU}{Residuals in \code{Tt} in \code{Tt} ~ \code{U}}
   \item{H_UT}{Residuals in \code{U} in \code{U} ~ \code{Tt}}
   \item{X_hat}{Prediction of \eqn{X} with \eqn{Y}}
   \item{Y_hat}{Prediction of \eqn{Y} with \eqn{X}}
   \item{R2X}{Variation (measured with \code{\link{ssq}}) of the modeled part in \eqn{X} (defined by joint + orthogonal variation) as proportion of variation in \eqn{X}}
   \item{R2Y}{Variation (measured with \code{\link{ssq}}) of the modeled part in \eqn{Y} (defined by joint + orthogonal variation) as proportion of variation in \eqn{Y}}
   \item{R2Xcorr}{Variation (measured with \code{\link{ssq}}) of the joint part in \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Ycorr}{Variation (measured with \code{\link{ssq}}) of the joint part in \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2X_YO}{Variation (measured with \code{\link{ssq}}) of the orthogonal part in \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Y_XO}{Variation (measured with \code{\link{ssq}}) of the orthogonal part in \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2Xhat}{Variation (measured with \code{\link{ssq}}) of the predicted \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Yhat}{Variation (measured with \code{\link{ssq}}) of the predicted \eqn{Y} as proportion of variation in \eqn{Y}}
}
\description{
NOTE THAT THIS FUNCTION DOES NOT CENTER NOR SCALES THE MATRICES! Any normalization you will have to do yourself. It is best practice to at least center the variables though.
}
\details{
If both \code{nx} and \code{ny} are zero, \code{o2m} is equivalent to PLS2 with orthonormal loadings.
This is a `slower' (in terms of memory) implementation of O2PLS, and is using \code{\link{svd}}, use \code{stripped=T} for a stripped version with less output.
If either \code{ncol(X) > p_thresh} or \code{ncol(Y) > q_thresh}, an alternative method is used (NIPALS) which does not store the entire covariance matrix.
The squared error between iterands in the NIPALS approach can be adjusted with \code{tol}.
The maximum number of iterations in the NIPALS approach is tuned by \code{max_iterations}.
}
\examples{
test_X <- scale(matrix(rnorm(100*10),100,10))
test_Y <- scale(matrix(rnorm(100*11),100,11))
#  --------- Default run ------------ 
o2m(test_X, test_Y, 3, 2, 1)
#  ---------- Stripped version ------------- 
o2m(test_X, test_Y, 3, 2, 1, stripped = TRUE)
#  ---------- High dimensional version ---------- 
o2m(test_X, test_Y, 3, 2, 1, p_thresh = 1)
#  ------ High D and stripped version --------- 
o2m(test_X, test_Y, 3, 2, 1, stripped = TRUE, p_thresh = 1)
#  ------ Now with more iterations -------- 
o2m(test_X, test_Y, 3, 2, 1, stripped = TRUE, p_thresh = 1, max_iterations = 1e6)
#  ---------------------------------- 

}
\seealso{
\code{\link{summary.o2m}}, \code{\link{plot.o2m}}, \code{\link{crossval_o2m}}
}
