% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFanalysis.R
\name{DFanalysis}
\alias{DFanalysis}
\title{DFanalysis}
\usage{
DFanalysis(data = NULL, proband, sibling, Rs, RK = T, robust = T,
  DE = T, betasonly = F, typicalSE = F)
}
\arguments{
\item{data}{A dataframe. This is not necessary as the variables can be passed directly via the other arguments.}

\item{proband}{Called "proband" for historical reasons this is the variable on the left hand side of the regression.}

\item{sibling}{The right hand side version of proband. This would be the matched sibling scores.}

\item{Rs}{This is the vector of relatedness coefficients}

\item{RK}{Use the Rodgers and Kohler simplified version of the DF model (recommended). Data should not be double entered prior to analysis.}

\item{robust}{Use the Kohler and Rodgers robust standard errors (recommeneded when using double entered data)}

\item{DE}{Will the data need to be double entered?}

\item{betasonly}{If TRUE only the beta weights from the regression analysis will be returned.}

\item{typicalSE}{Should the typical regression standard errors be used? Default is false.}
}
\value{
The results from MyLM
}
\description{
DFanalysis
}
\examples{
TwinData<-DFSimulated(2000,2000,.3,.3)
p<-TwinData[,1]
s<-TwinData[,2]
r<-TwinData[,3]
DFanalysis(data=NULL, p,s,r)
}
