% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{draws-OncoBayes2}
\alias{draws-OncoBayes2}
\alias{as_draws}
\alias{as_draws_matrix}
\alias{as_draws_array}
\alias{as_draws_df}
\alias{as_draws_rvars}
\alias{as_draws_list}
\alias{as_draws.blrmfit}
\alias{as_draws_matrix.blrmfit}
\alias{as_draws_array.blrmfit}
\alias{as_draws_df.blrmfit}
\alias{as_draws_list.blrmfit}
\alias{as_draws_rvars.blrmfit}
\title{Transform \code{blrmfit} to \code{draws} objects}
\usage{
\method{as_draws}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_matrix}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_array}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_df}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_list}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_rvars}{blrmfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)
}
\arguments{
\item{x}{A \code{blrmfit} object.}

\item{variable}{A character vector providing the variables to
extract.  By default, all variables are extracted.}

\item{regex}{Logical; Should variable be treated as a (vector of)
regular expressions? Any variable in \code{x} matching at least
one of the regular expressions will be selected. Defaults to
\code{FALSE}.}

\item{inc_warmup}{Should warmup draws be included? Defaults to
\code{FALSE}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Transform a \code{blrmfit} object to a format supported by the
\pkg{posterior} package.
}
\details{
To subset iterations, chains, or draws, use the
\code{\link[posterior:subset_draws]{subset_draws}} method after
transforming the \code{blrmfit} to a \code{draws} object.

The function is experimental as the set of exported posterior
variables are subject to updates.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(
  OncoBayes2.MC.warmup = 10, OncoBayes2.MC.iter = 20, OncoBayes2.MC.chains = 1,
  OncoBayes2.MC.save_warmup = FALSE
)

# fit an example model. See documentation for "combo2" example
example_model("combo2")

post <- as_draws(blrmfit)

## Recover user set sampling defaults
options(.user_mc_options)

}
\seealso{
\code{\link[posterior:draws]{draws}}
\code{\link[posterior:subset_draws]{subset_draws}}
}
