% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{check_for_malicious_files}
\alias{check_for_malicious_files}
\title{Check for Malicious Files}
\usage{
check_for_malicious_files(files)
}
\arguments{
\item{files}{A character vector of file paths. These can be paths to zip files or individual files.}
}
\value{
A logical value indicating if any of the files in the input have a malicious file extension. Returns `TRUE` if any malicious file is found, otherwise `FALSE`.
}
\description{
This function checks for the presence of files with extensions known to be associated with malicious activities. 
The function can be used to screen zip files or individual files for these potentially dangerous file types.
}
\examples{
\dontrun{
  check_for_malicious_files("path'(s)'/to/your/files")
  check_for_malicious_files(utils::unzip("path/to/your/file.zip", list = TRUE)$Name)
}

}
