% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{COVID19IBM}
\alias{COVID19IBM}
\title{R6Class COVID19IBM}
\description{
Environment subclass representing a COVID19 outbreak as defined
in the COVID19-IBM model.

See \code{\link{Simulation}} for examples.
}
\section{Super class}{
\code{\link[OpenABMCovid19:Environment]{OpenABMCovid19::Environment}} -> \code{COVID19IBM}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{An instance of the \code{\link{Model}} class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{COVID19IBM$new()}}
\item \href{#method-start_simulation}{\code{COVID19IBM$start_simulation()}}
\item \href{#method-end_simulation}{\code{COVID19IBM$end_simulation()}}
\item \href{#method-step}{\code{COVID19IBM$step()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="OpenABMCovid19" data-topic="Environment" data-id="start">}\href{../../OpenABMCovid19/html/Environment.html#method-start}{\code{OpenABMCovid19::Environment$start()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Environment subclass representing a COVID19 outbreak as
defined in the COVID19-IBM model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{COVID19IBM$new(model, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{An R6 \code{\link{Model}} class instance.}

\item{\code{...}}{Parameters to pass to Environment super class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-start_simulation}{}}}
\subsection{Method \code{start_simulation()}}{
Start a simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{COVID19IBM$start_simulation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The state of the system
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-end_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-end_simulation}{}}}
\subsection{Method \code{end_simulation()}}{
End the simulation. Destroy the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{COVID19IBM$end_simulation()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Run the simulation through one time step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{COVID19IBM$step(action)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{action}}{Vector of actions. The vector should contain names from
\code{\link{SAFE_UPDATE_PARAMS}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The state of the system.
}
}
}
