% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{resizeImage}
\alias{resizeImage}
\title{resize an image using the 'nearest neighbors' or the 'bilinear' method}
\usage{
resizeImage(image, width, height, method = "nearest")
}
\arguments{
\item{image}{matrix or 3-dimensional array}

\item{width}{a number specifying the new width of the image. Corresponds to the image-rows.}

\item{height}{a number specifying the new height of the image. Corresponds to the image-columns.}

\item{method}{one of 'nearest', 'bilinear'}
}
\value{
depending on the input, either a matrix or an array
}
\description{
resize an image using the 'nearest neighbors' or the 'bilinear' method
}
\details{
This function down- or upsamples an image using the 'nearest neighbors' or the 'bilinear' method
}
\examples{

path = system.file("tmp_images", "2.jpg", package = "OpenImageR")

image = readImage(path)

resiz = resizeImage(image, width = 32, height = 32, method = 'nearest')

}
\author{
Lampros Mouselimis
}

