% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{ZCAwhiten}
\alias{ZCAwhiten}
\title{zca whiten of an image}
\usage{
ZCAwhiten(image, k, epsilon)
}
\arguments{
\item{image}{a matrix, data frame or 3-dimensional array}

\item{k}{an integer specifying the number of components to keep when svd is performed (reduced dimension representation of the data)}

\item{epsilon}{a float specifying the regularization parameter}
}
\value{
a matrix or 3-dimensional array
}
\description{
this function performs zca-whitening to a 2- or 3- dimensional image
}
\details{
Whitening (or sphering) is the preprocessing needed for some algorithms. If we are training on images, the raw input is redundant, since adjacent
pixel values are highly correlated. When using whitening the features become less correlated and all features have the same variance.
}
\examples{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

image = readImage(path)

res = ZCAwhiten(image, k = 20, epsilon = 0.1)

}
\references{
http://ufldl.stanford.edu/wiki/index.php/Whitening
}
