% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{down_sample_image}
\alias{down_sample_image}
\title{downsampling an image ( by a factor ) using gaussian blur}
\usage{
down_sample_image(
  image,
  factor,
  gaussian_blur = FALSE,
  gauss_sigma = 1,
  range_gauss = 2
)
}
\arguments{
\item{image}{matrix or 3-dimensional array where the third dimension is equal to 3}

\item{factor}{a positive number greater or equal to 1.0}

\item{gaussian_blur}{a boolean (TRUE,FALSE) specifying if gaussian blur should be applied when downsampling}

\item{gauss_sigma}{float parameter sigma for the gaussian filter}

\item{range_gauss}{float number specifying the range of values for the gaussian filter}
}
\value{
depending on the input, either a matrix or an array
}
\description{
downsampling an image ( by a factor ) using gaussian blur
}
\details{
This function downsamples an image with the option to use gaussian blur for optimal output.
}
\examples{

path = system.file("tmp_images", "2.jpg", package = "OpenImageR")

image = readImage(path)

dsamp = down_sample_image(image, factor = 2.0, gaussian_blur = TRUE)

}
\author{
Lampros Mouselimis
}
