% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeStandardError}
\alias{mxComputeStandardError}
\alias{MxComputeStandardError-class}
\title{Compute standard errors}
\usage{
mxComputeStandardError(freeSet = NA_character_,
  fitfunction = "fitfunction")
}
\arguments{
\item{freeSet}{names of matrices containing free variables}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}
}
\description{
When the fit is in -2 log likelihood units, the SEs are derived
from the diagonal of the Hessian or inverse Hessian. The Hessian
(in some form) must already be available.
}
\details{
If there are active MxConstraints and the fit is in -2logL units,
the SEs are derived from the Hessian and the Jacobian of the 
constraint functions (see references).
}
\references{
Moore T & Sadler B.  (2006).  \emph{Maximum-Likelihood Estimation and 
     Scoring Under Parametric Constraints}.  Army Research Laboratory 
     report ARL-TR-3805.
Schoenberg R.  (1997).  Constrained maximum likelihood.
     \emph{Computational Economics, 10}, p. 251-266.
}
