% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_OpenSpecy.R
\name{head.OpenSpecy}
\alias{head.OpenSpecy}
\alias{print.OpenSpecy}
\alias{plot.OpenSpecy}
\alias{lines.OpenSpecy}
\alias{summary.OpenSpecy}
\alias{as.data.frame.OpenSpecy}
\alias{as.data.table.OpenSpecy}
\title{Generic Open Specy Methods}
\usage{
\method{head}{OpenSpecy}(x, ...)

\method{print}{OpenSpecy}(x, ...)

\method{plot}{OpenSpecy}(x, ...)

\method{lines}{OpenSpecy}(x, ...)

\method{summary}{OpenSpecy}(object, ...)

\method{as.data.frame}{OpenSpecy}(x, ...)

\method{as.data.table}{OpenSpecy}(x, ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object.}

\item{object}{an \code{OpenSpecy} object.}

\item{\ldots}{further arguments passed to the respective default method.}
}
\value{
\code{head()}, \code{print()}, and \code{summary()} return a textual
representation of an \code{OpenSpecy} object.
\code{plot()} and \code{lines()} return a plot.
\code{as.data.frame()} and \code{as.data.table()} convert \code{OpenSpecy}
objects into tabular data.
}
\description{
Methods to visualize and convert \code{OpenSpecy} objects.
}
\details{
\code{head()} shows the first few lines of an \code{OpenSpecy} object.
\code{print()} prints the contents of an \code{OpenSpecy} object.
\code{summary()} produces a result summary of an \code{OpenSpecy} object.
\code{plot()} produces a \code{\link[graphics]{matplot}()} of an OpenSpecy
object; \code{lines()} adds new spectra to it.
}
\examples{
data("raman_hdpe")

# Printing the OpenSpecy object
print(raman_hdpe)

# Displaying the first few lines of the OpenSpecy object
head(raman_hdpe)

# Plotting the spectra
plot(raman_hdpe)

}
\seealso{
\code{\link[utils]{head}()}, \code{\link[base]{print}()},
\code{\link[base]{summary}()}, \code{\link[graphics]{matplot}()}, and
\code{\link[graphics]{matlines}()},
\code{\link[base]{as.data.frame}()},
\code{\link[data.table]{as.data.table}()}
}
\author{
Zacharias Steinmetz, Win Cowger
}
