------------------------------------------------------------------------

## Description

Provides details such as Morphine Equivalent Dose (MED), brand name and
opioid content which are calculated of all oral opioids authorized for
sale by Health Canada based on their Drug Identification Number (DIN) or
FDA based on their Product ID for Opioids authorized for sale in
Canadian or US markets. For US Opioids, MEDs are calculated using Von
Korff et al. (2008) and information obtained from FDA’s daily National
Drug Code Directory \[/drug/ndc\] download MEDs are calculated based on
recommendations by Canadian Institute for Health Information (CIHI) and
information obtained from Health Canada’s Drug Product Database’s
monthly data dump for Canadian Opioids. Please note in no way should
output from this package be a substitute for medical advise.  
All medications should only be consumed on prescription from a licensed
healthcare provider

------------------------------------------------------------------------

## Functions

### Loading/updating the FDA dataset

    library(OralOpioids)
    US_Opioid_Table <- load_Opioid_Table(country="US")

    Your FDA_Opioid_Table is outdated. Do you want to download  the latest data from FDA? (y/n) 

    1: Y
    2: N

    Selection: Y

    trying URL 'https://download.open.fda.gov/drug/ndc/drug-ndc-0001-of-0001.json.zip'
    Content type 'application/zip' length 27647880 bytes (26.4 MB)
    downloaded 26.4 MB

    The FDA_Opioid_Table was successfully updated to 2023-12-20.
    DISCLAIMER: Not a substitute for medical advise. Please note that the output generated by the package should not be substituted for clinical advise and any medication should be only consumed at the advise of a licensed healthcare provider.

    Source url of the data: https://download.open.fda.gov/drug/ndc/drug-ndc-0001-of-0001.json.zip
    Source url used for dosing: Von Korff M, Saunders K, Thomas Ray G, et al. De facto long-term opioid therapy for noncancer pain. Clin J Pain 2008; 24: 521-527. 2008/06/25. DOI: 10.1097/AJP.0b013e318169d03b.

    head(US_Opioid_Table)

        Drug_ID                             name strength Base1 Base2 Base3                                                            Brand
    1 0054-0176      BUPRENORPHINE HYDROCHLORIDE   2 mg/1   2.0     1                                                      Buprenorphine HCl
    2 0054-0177      BUPRENORPHINE HYDROCHLORIDE   8 mg/1   8.0     1                                                      Buprenorphine HCl
    3 0054-0188      BUPRENORPHINE HYDROCHLORIDE   2 mg/1   2.0     1       buprenorphine hydrochloride and naloxone hydrochloride dihydrate
    4 0054-0188 NALOXONE HYDROCHLORIDE DIHYDRATE  .5 mg/1   0.5     1       buprenorphine hydrochloride and naloxone hydrochloride dihydrate
    5 0054-0189      BUPRENORPHINE HYDROCHLORIDE   8 mg/1   8.0     1       buprenorphine hydrochloride and naloxone hydrochloride dihydrate
    6 0054-0189 NALOXONE HYDROCHLORIDE DIHYDRATE   2 mg/1   2.0     1       buprenorphine hydrochloride and naloxone hydrochloride dihydrate
                                                                  active_ingredients marketing_category   Form      Route
    1                                            BUPRENORPHINE HYDROCHLORIDE, 2 mg/1               ANDA TABLET SUBLINGUAL
    2                                            BUPRENORPHINE HYDROCHLORIDE, 8 mg/1               ANDA TABLET SUBLINGUAL
    3 BUPRENORPHINE HYDROCHLORIDE, NALOXONE HYDROCHLORIDE DIHYDRATE, 2 mg/1, .5 mg/1               ANDA TABLET SUBLINGUAL
    4 BUPRENORPHINE HYDROCHLORIDE, NALOXONE HYDROCHLORIDE DIHYDRATE, 2 mg/1, .5 mg/1               ANDA TABLET SUBLINGUAL
    5  BUPRENORPHINE HYDROCHLORIDE, NALOXONE HYDROCHLORIDE DIHYDRATE, 8 mg/1, 2 mg/1               ANDA TABLET SUBLINGUAL
    6  BUPRENORPHINE HYDROCHLORIDE, NALOXONE HYDROCHLORIDE DIHYDRATE, 8 mg/1, 2 mg/1               ANDA TABLET SUBLINGUAL
                                                                                Opioid      Opioid_1 MED_per_dispensing_unit
    1                                             BUPRENORPHINE HYDROCHLORIDE 2 mg/1   BUPRENORPHINE                      NA
    2                                             BUPRENORPHINE HYDROCHLORIDE 8 mg/1   BUPRENORPHINE                      NA
    3 BUPRENORPHINE HYDROCHLORIDE 2 mg/1  + NALOXONE HYDROCHLORIDE DIHYDRATE .5 mg/1   BUPRENORPHINE                      NA
    4 BUPRENORPHINE HYDROCHLORIDE 2 mg/1  + NALOXONE HYDROCHLORIDE DIHYDRATE .5 mg/1        NALOXONE                      NA
    5  BUPRENORPHINE HYDROCHLORIDE 8 mg/1  + NALOXONE HYDROCHLORIDE DIHYDRATE 2 mg/1   BUPRENORPHINE                      NA
    6  BUPRENORPHINE HYDROCHLORIDE 8 mg/1  + NALOXONE HYDROCHLORIDE DIHYDRATE 2 mg/1        NALOXONE                      NA
      No_tabs/ml assuming 50 MED limit per day No_tabs/ml assuming 90 MED limit per day Maximum No_tabs/ml assuming 50 MED limit for 7 days
    1                                       NA                                       NA                                                  NA
    2                                       NA                                       NA                                                  NA
    3                                       NA                                       NA                                                  NA
    4                                       NA                                       NA                                                  NA
    5                                       NA                                       NA                                                  NA
    6                                       NA                                       NA                                                  NA
      Maximum No_tabs/ml assuming 50 MED limit for 14 days Maximum No_tabs/ml assuming 50 MED limit for 30 days last_updated
    1                                                   NA                                                   NA   2023-12-20
    2                                                   NA                                                   NA   2023-12-20
    3                                                   NA                                                   NA   2023-12-20
    4                                                   NA                                                   NA   2023-12-20
    5                                                   NA                                                   NA   2023-12-20
    6                                                   NA                                                   NA   2023-12-20

### Loading/updating the Health Canada dataset

    library(OralOpioids)
    Canada_Opioid_Table <- load_Opioid_Table(country="Canada")

    ## No HealthCanada_Opioid_Tables are currently in the filelocation. Do you want to download  the latest data from Health Canada? (y/n)  
    ## 
    ## 1: Y
    ## 2: N
    ## 
    ## Selection: Y
    ## trying URL 'https://www.canada.ca/content/dam/hc-sc/documents/services/drug-product-database/allfiles.zip'
    ## Content type 'application/zip' length unknown
    ## downloaded 1.4 MB
    ## 
    ## trying URL 'https://www.canada.ca/content/dam/hc-sc/documents/services/drug-product-database/allfiles_ap.zip'
    ## Content type 'application/zip' length unknown
    ## downloaded 407 KB
    ## 
    ## trying URL 'https://www.canada.ca/content/dam/hc-sc/documents/services/drug-product-database/allfiles_dr.zip'
    ## Content type 'application/zip' length unknown
    ## downloaded 317 KB
    ## 
    ## trying URL 'https://www.canada.ca/content/dam/hc-sc/documents/services/drug-product-database/allfiles_ia.zip'
    ## Content type 'application/zip' length unknown
    ## downloaded 4.9 MB
    ## 
    ## The HealthCanada_Opioid_Table was successfully updated to 2023-01-03.
    ## DISCLAIMER: Not a substitute for medical advise. Please note that the output generated by the package should not be substituted for clinical advise and any medication ## should be only consumed at the advise of a licensed healthcare provider.
    ## 
    ## Source url of the data: https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/what-data-extract-drug-product-database.html
    ## Source url used for dosing: https://www.cihi.ca/sites/default/files/document/opioid-prescribing-canada-trends-en-web.pdf

    head(Canada_Opioid_Table)

    ##       DIN MED_per_dispensing_unit Base1 Base2 Base3             Opioid      Route   Form                       Brand No_tabs/ml assuming 50 MED limit per day
    ## 1 2517175  Couldn't be calculated     1     N       BUPRENORPHINE 2 MG SUBLINGUAL TABLET TARO-BUPRENORPHINE/NALOXONE                   Couldn't be calculated
    ## 2 2517175  Couldn't be calculated     1     N          NALOXONE 0.5 MG SUBLINGUAL TABLET TARO-BUPRENORPHINE/NALOXONE                   Couldn't be calculated
    ## 3 2517183  Couldn't be calculated     1     N       BUPRENORPHINE 8 MG SUBLINGUAL TABLET TARO-BUPRENORPHINE/NALOXONE                   Couldn't be calculated
    ## 4 2517183  Couldn't be calculated     1     N            NALOXONE 2 MG SUBLINGUAL TABLET TARO-BUPRENORPHINE/NALOXONE                   Couldn't be calculated
    ## 5 2518759                       5     1     N           TRAMADOL 50 MG       ORAL TABLET           JAMP TRAMADOL HCL                                       10
    ## 6  763527                     1.2     1     N             CODEINE 8 MG       ORAL TABLET            ORADRINE TABLETS                                       42
    ##   No_tabs/ml assuming 90 MED limit per day Maximum No_tabs/ml assuming 50 MED limit for 7 days Maximum No_tabs/ml assuming 50 MED limit for 14 days
    ## 1                   Couldn't be calculated                              Couldn't be calculated                               Couldn't be calculated
    ## 2                   Couldn't be calculated                              Couldn't be calculated                               Couldn't be calculated
    ## 3                   Couldn't be calculated                              Couldn't be calculated                               Couldn't be calculated
    ## 4                   Couldn't be calculated                              Couldn't be calculated                               Couldn't be calculated
    ## 5                                       18                                                  70                                                  140
    ## 6                                       75                                                 294                                                  588
    ##   Maximum No_tabs/ml assuming 50 MED limit for 30 days              Status_1 last_updated
    ## 1                               Couldn't be calculated              APPROVED   2023-01-03
    ## 2                               Couldn't be calculated              APPROVED   2023-01-03
    ## 3                               Couldn't be calculated              APPROVED   2023-01-03
    ## 4                               Couldn't be calculated              APPROVED   2023-01-03
    ## 5                                                  300              APPROVED   2023-01-03
    ## 6                                                 1260 CANCELLED POST MARKET   2023-01-03

### Get the Morphine Equivalent Dose (MED) from FDA by using the Product ID

    MED("0093-0058",US_Opioid_Table)

    [1] 5

### Get the Morphine Equivalent Dose (MED) from Health Canada by using DIN

    MED(786535, Canada_Opioid_Table)

    [1] 5

### Get the Brand name from FDA by using the Product ID

    Brand("0093-0058", US_Opioid_Table)

    [1] "Tramadol Hydrochloride"

### Get the Brand name from Health Canada by using DIN

    Brand(786535, Canada_Opioid_Table)

    [1] "DILAUDID"

### Get the Opioid content from FDA by using the Product ID

    Opioid("0093-0058",US_Opioid_Table)

    [1] "TRAMADOL HYDROCHLORIDE 50 mg/1  "

### Get the Opioid content from Health Canada by using DIN

    Opioid(786535, Canada_Opioid_Table)

    [1] "HYDROMORPHONE 1 MG"

### Get the Maximum number of units/millilitres of oral opioids allowed per day assuming a daily limit of 50 MED/day from FDA by using the Product ID

    MED_50("0093-0058",US_Opioid_Table)

    [1] 10

### Get the Maximum number of units/millilitres of oral opioids allowed per day assuming a daily limit of 50 MED/day from Health Canada by using DIN

    MED_50(786535, Canada_Opioid_Table)

    [1] 10

### Get the Maximum number of units/millilitres of oral opioids allowed per day assuming a daily limit of 90 MED/day from FDA by using the Product ID

    MED_90("0093-0058",US_Opioid_Table)

    [1] 18

### Get the Maximum number of units/millilitres of oral opioids allowed per day assuming a daily limit of 90 MED/day from Health Canada by using DIN

    MED_90(786535, Canada_Opioid_Table)

    [1] 18
