% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{labels_function}
\alias{labels_function}
\title{Label Caculation Function}
\usage{
labels_function(centers, observations)
}
\arguments{
\item{centers}{a matrix containing m centers of length d, where each row corresponds to coordinates of a center.}

\item{observations}{a matrix containing T observations of length d, where each row of the matrix is an observation of length d.}
}
\value{
cluster label of each of the observations.
}
\description{
This function gives cluster label to each of the observations.
}
\details{
Given a set \emph{C} of m centers of length d (\emph{i.e.,} \emph{C} = \eqn{{c_{1}, c_{2}, \dots, c_{m}}}), and a set \emph{X} of T observations of length d (\emph{i.e.,} \emph{X} = \eqn{{x_{1}, x_{2}, \dots, x_{T}}}), this function associates each observation \eqn{x_{t}} to the nearest centers to form different cells, and gives a corresponding cluster label to it.
}
\examples{
## generating 4 centers of length 3.
centers <- matrix(1:12, nrow = 4, ncol = 3)
## generating 10 observations of length 3.
observations <- matrix(rmnorm(10, mean = c(2,6,10), varcov = diag(1,3)), nrow = 10)
labels_function(centers, observations)
}
\keyword{internal}

