\name{read.rarecol}

\alias{read.rarecol}

\title{Read files containing rarefaction curves of colonization events}

\description{
    An import method for data generated by \code{\link{rarecol}}.
}

\usage{
read.rarecol(gen, field)
}

\arguments{
    \item{gen, field}{
        filenames of genetic and field estimation data.
    }
}

\details{
    This function uses \code{\link[utils]{read.table}} to import both files
    created by \code{\link{rarecol}}.
}

\value{
    This function returns an object of \code{\link[base]{class}} \code{rarecol}.
    This object is a list in which each element is a data.frame containing
    information about colonization inference.
}

\references{
    Coello, A.J., Fernandez-Mazuecos, M., Heleno, R.H., Vargas, P. (2022).
    PAICE: A new R package to estimate the number of inter-island colonizations
    considering haplotype data and sample size. \emph{Journal of Biogeography},
    49(4), 577-589.DOI:
    \href{https://onlinelibrary.wiley.com/doi/10.1111/jbi.14341}{10.1111/jbi.14341}
}

\seealso{
    \code{\link{rarecol}} for building of rarefaction curves of colonization
    events.
}

\examples{\donttest{
data(CmonsData)
data(CmonsNetwork)
# Make rarefaction curves and save it in working directory,
## Note: only one replicate per sampling to it quickly
rarecol(data = CmonsData, network = CmonsNetwork,
        replicates_field = 1, replicates_genetic = 1,
        monitor = TRUE, file = "rareData")
# Genetic estimation has the suffix "_gen" and the field "_field"
raredata <- read.rarecol(gen = "rareData_gen.csv",
                         field = "rareData_field.csv")
str(raredata) # Show structure of data imported
# Remove files created
file.remove("rareData_gen.csv", "rareData_field.csv")
}}

\keyword{ file }
