% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvCalcBulk.R
\name{cvCalcBulk}
\alias{cvCalcBulk}
\title{cvCalcBulk Function}
\usage{
cvCalcBulk(
  data_object,
  meanThreshold = 1,
  cvThreshold = 5,
  median_cvThreshold = NULL,
  donorThreshold = NULL,
  housekeeping_genes = NULL,
  naThreshold = 1,
  plot_log10 = FALSE,
  selectedFeatures = NULL,
  median_cv_max = NULL,
  plotWidth = 5,
  plotHeight = 8,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. Contains annotation table
and expression matrix or data frame. Rows represent gene/proteins column
represents participant samples (same as annotation table Sample column)}

\item{meanThreshold}{Average expression threshold to filter lowly expressed
genes Default is 1 (log2 scale)}

\item{cvThreshold}{Coefficient of variation threshold to select variable and
stable genes. Default is 5 for bulk data. Users can use 10-20 for single cell
average expression data.}

\item{median_cvThreshold}{Optional, median of CVs from each donor/participant
calculated. Threshold used to differentiate variable and stable features
across donors/participants. Default, same as \emph{cvThreshold}.}

\item{donorThreshold}{Donor threshold number to be used, Default is number of
participants}

\item{housekeeping_genes}{Optional, vector of housekeeping genes. Default is
c("ACTB", "GAPDH")}

\item{naThreshold}{Optional, For a give feature \% of donors/participants
showing non-NA CVs (NAs appear due to expression ~0 or absent). Default is 1
means all donors/participants to consider. 0.5 means from 4 donors atleast 2
donors should have non-NA CVs for a given feature.}

\item{plot_log10}{Optional, Plot CV vs Mean on log10 scale. Default FALSE}

\item{selectedFeatures}{Optional, focus on selected genes/features.}

\item{median_cv_max}{Optional, Remove features with greater than median CV
Default is NULL}

\item{plotWidth}{Optional, heat plot width 5 in}

\item{plotHeight}{Optional, heat plot height 8 in}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory PATH Default, current directory}
}
\value{
PALMO object with CV list
}
\description{
This function allows to calculate Intra-donor variations in bulk data over
longitudinal timepoints. The coefficient of variation (CV=SD/mean) is
calculated in Bulk data in same donor/participant across timepoints.
}
\examples{
\dontrun{
palmo_obj=cvCalcBulk(data_object=palmo_obj, meanThreshold=0.1, cvThreshold=5)
}
}
\keyword{cvCalcBulk}
