% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_correlation.R
\name{sample_correlation}
\alias{sample_correlation}
\title{sample_correlation Function}
\usage{
sample_correlation(
  data_object,
  cor_method = "spearman",
  group_by = NULL,
  col_break = NULL,
  col_max = 1,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  column_names_fontsize = 4,
  row_names_fontsize = 4,
  row_title_fontsize = 6,
  column_title_fontsize = 6,
  plotHeight = 20,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation information
and expression data from Bulk or single cell data.}

\item{cor_method}{(Optional) Correlation method 'pearson' or 'spearman'. Default
is 'spearman'}

\item{group_by}{Cluster correlation heat plot by 'donor' or 'group'}

\item{col_break}{Value between 0 and 1}

\item{col_max}{Maximum color limit (Default 1)}

\item{cluster_rows}{\emph{ComplexHeatmap} cluster rows, Default FALSE}

\item{cluster_columns}{\emph{ComplexHeatmap} cluster columns, Default FALSE}

\item{column_names_fontsize}{Font size of the column names, Default 4}

\item{row_names_fontsize}{Font size of the row names, Default 4}

\item{row_title_fontsize}{Font size of the row title, Default 6}

\item{column_title_fontsize}{Font size of the column title, Default 6}

\item{plotHeight}{Height of the plot in inch, Default 20 in}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
PALMO object with correlation cor_res dataframe
}
\description{
This function allows to perform sample correlation (by group like
celltype, or by donor).
}
\examples{
\dontrun{
palmo_obj <- sample_correlation(data_object=palmo_obj, group_by="Time")
}
}
\keyword{sample_correlation}
