% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSettings.R
\name{addSettings}
\alias{addSettings}
\title{Add Settingss to a PAMpalSettings Object}
\usage{
addSettings(pps, settings = NULL, type = c("xml", "list"), verbose = TRUE)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to add settings to}

\item{settings}{settings to add, either an XML file or a}

\item{type}{one of 'xml' or 'list' indicating type of settings to add}

\item{verbose}{logical flag to show messages}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with a new
  list of settings replacing what was previously in the "settings" slot
}
\description{
Adds settings to a PAMpalSettings object, usually
  from an XML file created by Pamguard's "Export XML Configuration"
}
\examples{

# not recommended to create PPS like this, for example only
pps <- new('PAMpalSettings')
xmlSettings <- system.file('extdata', 'Example.xml', package='PAMpal')
pps <- addSettings(pps, xmlSettings, type='xml')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
