% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{PAMpalSettings-class}
\alias{PAMpalSettings-class}
\title{\code{PAMpalSettings} Class}
\description{
An S4 class that stores settings related to all processing and analysis steps
done in PAMpal. A PAMpalSettings object will be the main input to any major function
in the PAMpal package.
}
\section{Slots}{

\describe{
\item{\code{db}}{the full path to a PamGuard database file}

\item{\code{binaries}}{a list with items "folder" containing the directory of the
PamGuard binary files, and "list" containing the full path to each individual
binary file.}

\item{\code{functions}}{a named list of functions to apply to data read in by PAMpal.
Should be named by the PamGuard module the function should be applied to.
Currently supports "ClickDetector", "WhistlesMoans", and "Cepstrum".}

\item{\code{calibration}}{a named list of calibration functions to apply while
applying functions from the "functions" slot. Should named by the
PamGuard module, same as the "functions"}

\item{\code{settings}}{a named list of settings, usually imported from Pamguard's
"Export XML Configuration"}
}}

\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
