% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSpecies.R
\name{setSpecies}
\alias{setSpecies}
\title{Set the Species Classification of Events}
\usage{
setSpecies(x, method = c("pamguard", "manual", "reassign"), value, type = "id")
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object, a list of \linkS4class{AcousticEvent}
objects, or a single \linkS4class{AcousticEvent} object}

\item{method}{the method for assigning species to an event. Currently supports
\code{pamguard}, which will use the 'eventType' or 'Text_Annotation' column
to assign species, \code{manual} which will use \code{value} to assign
species manually, or \code{reassign} which will use \code{value} to
reassign an old species label to a new one}

\item{value}{required only if \code{method} is set to 'manual' or 'reassign'.
For \code{'manual'}, can either be a single value to assign to all events, or a
vector with length equal to the number of events. Can also be a dataframe
with columns \code{event} and \code{species}, in which case species will
be matched to corresponding event names instead of just relying on the
order. If using this, please note the prefix OE or DGL present on most
event numbers (see the \code{id} slot of your events, or \code{names(events(x))}).
For \code{'reassign'}, \code{value} must be a data frame with columns
\code{old} and \code{new}. Any events with species id in the \code{old} column
of the dataframe will get reassigned to the corresponding id in the
\code{new} column.}

\item{type}{the type of classification to set, this is just a label within
the \code{species} slot. Default \code{'id'} should typically not be changed
since this is used by other functions}
}
\value{
the same object as \code{x}, with species identifications assigned
  as an item named \code{type} in the \code{species} slot
}
\description{
Sets the \code{species} slot of \linkS4class{AcousticEvent}
  objects within an \linkS4class{AcousticStudy}
}
\examples{

# setting up example data
exPps <- new('PAMpalSettings')
exPps <- addDatabase(exPps, system.file('extdata', 'Example.sqlite3', package='PAMpal'))
exPps <- addBinaries(exPps, system.file('extdata', 'Binaries', package='PAMpal'))
exClick <- function(data) {
    standardClickCalcs(data, calibration=NULL, filterfrom_khz = 0)
}
exPps <- addFunction(exPps, exClick, module = 'ClickDetector')
exPps <- addFunction(exPps, roccaWhistleCalcs, module='WhistlesMoans')
exPps <- addFunction(exPps, standardCepstrumCalcs, module = 'Cepstrum')
exData <- processPgDetections(exPps, mode='db')
exData <- setSpecies(exData, method='pamguard')
species(exData)
exData <- setSpecies(exData, method='manual', value = c('sp1', 'sp2'))
species(exData)
exData <- setSpecies(exData, method='reassign',
                     value = data.frame(old='sp1', new='sp3'))
species(exData)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
