% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTimeseries.R
\name{plotTimeseries}
\alias{plotTimeseries}
\title{Plot Timeseries}
\usage{
plotTimeseries(
  x,
  bin = "1hour",
  column,
  title = NULL,
  units = NULL,
  style = c("line", "heatmap"),
  q = 0,
  by = NULL,
  cmap = viridis_pal()(25),
  toTz = "UTC"
)
}
\arguments{
\item{x}{a dataframe with column \code{UTC}}

\item{bin}{time bin for summarising data. The median of values
within the same time bin will be plotted}

\item{column}{the name of the column to plot}

\item{title}{title for the plot, if left as default \code{NULL} it
will use the \code{column} name}

\item{units}{name of units for plot labeling, default is taken from
common soundscape units}

\item{style}{one of \code{'line'} or \code{'heatmap'}. \code{'line'}
will create a simple line time series plot, \code{'heatmap'} will create
a grid plot with hour of day as X-axis and Date as y-axis where the
value of \code{column} is the color}

\item{q}{only valid for \code{style='line'}, quantile level for plotting,
between 0 and 1.
If left as \code{0}, none will be plotted. If a single value, then
levels \code{q} and \code{1-q} will be plotted. Users can also
specify both values for non-symmettric intervals.}

\item{by}{only valid for \code{style='line'}, optional categorical
column to plot separate lines for}

\item{cmap}{only valid for \code{style='heatmap'}, the color palette to
use for plotting values}

\item{toTz}{timezone to use for the time axis (input data must be UTC).
Specification must be from \link{OlsonNames}}
}
\value{
a ggplot object
}
\description{
Plot simple timeseries of values
}
\examples{
manta <- loadSoundscapeData(system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes'))
plotTimeseries(manta, bin='1minute', column='HMD_150')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
